<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Doctor;
use App\Models\Paciente;
use App\Models\Protesis_3;
use App\Models\ProtesisFija;
use App\Models\ProtesisRemovible;
use App\Models\ProtesisTotal;
use App\Models\Tratamientoprotecis;
use Illuminate\Http\Request;

class ProtecisController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function removibles(Request $data)
    {
        $protesis = $this->removibleAux($data);
        $pac = Paciente::find($data->id_paciente);
        $doc = Doctor::all();
        return view('reports.consentimientos.protesis.removible', ['pro' => $protesis, 'doc' => $doc, 'paciente' => $pac]);
    }

    public function fijas(Request $data)
    {
        $protesis = $this->fijasAux($data);
        $doc = Doctor::all();
        $pac = Paciente::find($data->id_paciente);
        return view('reports.consentimientos.protesis.fija', ['pro' => $protesis, 'doc' => $doc, 'pac' => $pac]);
    }


    public function protesisDetail(Request $data)
    {
        $protesis = $this->protesisAux($data);
        $odontoHis = Tratamientoprotecis::where('paciente_id', $data->id_paciente)
            ->get();
        $pac = Paciente::find($data->id_paciente);
        $doc = Doctor::all();

        return view('reports.consentimientos.protesis.details', ['pro' => $protesis, 'odonto'  => $odontoHis, 'doc' => $doc, 'pac' => $pac]);
    }

    public function proTotal(Request $data)
    {
        $protesis = $this->totalAux($data);
        $pac = Paciente::find($data->id_paciente);
        $doc = Doctor::all();
        return view('reports.consentimientos.protesis.total', ['pro' => $protesis, 'doc' => $doc, 'pac' => $pac]);
    }

    // protesisi Total
    public function totalAux(Request $data)
    {
        $protesis = ProtesisTotal::where('paciente_id', $data->id_paciente)
            ->where('superior', $data->pieza)
            ->orwhere('inferior', $data->pieza)
            ->first();
        return $protesis;
    }

    public function totalSave(Request $data)
    {
        $protesis = ProtesisTotal::where('paciente_id', $data->id)
            ->where('hoja', $data->hoja)
            ->first();
        // $protesis->piezas = $data->piezas;
        $protesis->fecha1 = $data->fecha1;
        $protesis->fecha2 = $data->fecha2;
        $protesis->fecha3 = $data->fecha3;
        $protesis->fecha4 = $data->fecha4;
        $protesis->fecha5 = $data->fecha5;
        $protesis->fecha6 = $data->fecha6;
        $protesis->fecha7 = $data->fecha7;
        $protesis->fecha8 = $data->fecha8;
        $protesis->fecha9 = $data->fecha9;
        $protesis->fecha10 = $data->fecha10;
        $protesis->doc1 = $data->doc1;
        $protesis->doc2 = $data->doc2;
        $protesis->doc3 = $data->doc3;
        $protesis->doc4 = $data->doc4;
        $protesis->doc5 = $data->doc5;
        $protesis->doc6 = $data->doc6;
        $protesis->doc7 = $data->doc7;
        $protesis->doc8 = $data->doc8;
        $protesis->doc9 = $data->doc9;
        $protesis->doc10 = $data->doc10;
        $protesis->cortes = $data->cortes;
        $protesis->cementadocon = $data->cementado;
        $protesis->cementarios = $data->obserCement;
        $protesis->tecnicautilizada = $data->tecImpre;
        $protesis->pruebametal = $data->pruMetal;
        $protesis->espesor3mm = $data->espesorMetla;
        $protesis->bizcocho = $data->bizcocho;
        $protesis->colorpieza = $data->colorPiezas;
        $protesis->pontico = $data->pontico;
        $protesis->pre_cementado = $data->precemtado;
        $protesis->e_exceso = $data->excesos;
        $protesis->cementadadocon2 = $data->cementadocon;
        $protesis->observaciones = $data->observacionesFinal;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS']);
    }

    // potesis odonto logia
    public function protesisAux(Request $data)
    {
        $protesis = Protesis_3::where('paciente_id', $data->id_paciente)
            ->where('pieza', $data->pieza)
            ->first();
        return $protesis;
    }

    public function protesisSave(Request $data)
    {
        $protesis = Protesis_3::where('paciente_id', $data->id_paciente)
            ->where('hoja', $data->hoja)
            ->first();
        $protesis->fecha = $data->fecha;
        $protesis->pieza = $data->pieza;
        $protesis->traumatismo = $data->traumatismo;
        $protesis->caries = $data->caries;
        $protesis->expocariosa = $data->cariosa;
        $protesis->expomecanica = $data->mecanica;
        $protesis->resdeficiente = $data->deficiente;
        $protesis->rdp = $data->rpd;
        $protesis->pulpotomia = $data->pulpotomia;
        $protesis->pulpectomia = $data->pulpectomia;
        $protesis->tcr = $data->tcr;
        $protesis->dolorAsintomatico = $data->docasintomatico;
        $protesis->dolorEspontaneo = $data->docespontaneo;
        $protesis->dolorProvocado = $data->docprovocado;
        $protesis->dolorLocalizado = $data->localizado;
        $protesis->dolorDifuso = $data->docdifuso;
        $protesis->dolorCorto = $data->dolorcorto;
        $protesis->dolorProlongado = $data->dolorprolongado;
        $protesis->edema = $data->edema;
        $protesis->pruebaAsintomatica = $data->termicaasintomatica;
        $protesis->pruebaCorta = $data->termicacorta;
        $protesis->pruebaprolongada = $data->termicaprolongado;
        $protesis->mucosaAsintomatica = $data->mucosaasintomatica;
        $protesis->mucosaSintomatica = $data->mucosasintomatica;
        $protesis->percusionAsintomatica = $data->percusionasintomatica;
        $protesis->percusionLeve = $data->percusionleve;
        $protesis->percusionSevera = $data->percusionSevera;
        $protesis->estadoNormal = $data->perionormal;
        $protesis->estadoMovilidad = $data->periomovilidad;
        $protesis->estadoSignificativa = $data->periosignificativa;
        $protesis->fistulaAusente = $data->fistulaAusente;
        $protesis->fistulaPresente = $data->fistulaPresente;
        $protesis->rNormal = $data->hnorma;
        $protesis->lpd = $data->hlpd;
        $protesis->radiomax = $data->hradiolucidezmax;
        $protesis->radiomin = $data->hradiolucidesmin;
        $protesis->curvatura = $data->hapical;
        $protesis->rInt = $data->hint;
        $protesis->rExt = $data->hext;
        $protesis->obturacion = $data->hdeficiente;
        $protesis->radicular = $data->hfractura;
        $protesis->perforacion = $data->hperforacion;
        $protesis->poste = $data->hposte;
        $protesis->rfracturado = $data->hinstrumento;
        $protesis->apiceinmaduro = $data->hapice;
        $protesis->preversible = $data->dxreversible;
        $protesis->pirreversible = $data->dxirreversible;
        $protesis->nrecosis = $data->dxnecrosis;
        $protesis->paa = $data->dxpaa;
        $protesis->aaa = $data->dxaaa;
        $protesis->pac = $data->dxpac;
        $protesis->aac = $data->dxaac;
        $protesis->afenix = $data->dxafenix;
        $protesis->osteitis = $data->dxcondensante;
        $protesis->reservado = $data->pronosreservado;
        $protesis->favorable = $data->pronosfavorable;
        $protesis->observaciones = $data->observacionesIniciales;
        $protesis->conductometria = $data->conductometria;
        $protesis->lanatomica = $data->limaanatomica;
        $protesis->lmaestra = $data->limamaestra;
        $protesis->cmaestro = $data->conomaestro;
        $protesis->irrigantes = $data->irrigante;
        $protesis->sellador = $data->sellador;
        $protesis->medicamento = $data->medicintraconducto;
        $protesis->antinflamatorio = $data->antinflamatorio;
        $protesis->antibioterapia = $data->antibioterapia;
        $protesis->mes1 = $data->primermes;
        $protesis->mes3 = $data->tresmeses;
        $protesis->mes6 = $data->seismeses;
        $protesis->cx = $data->cx2;
        $protesis->complementarios = $data->txcomplemetarios;

        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS']);
    }

    // historial de tratamientos
    public function histrataSave(Request $data)
    {
        $his = new TratamientoProtecis();
        $his->pacieente_id = $data->id_paciente;
        $his->tratamiento = $data->tratamiento3;
        $his->doctor = $data->doc;
        $his->fecha = date('Y-m-d');
        $his->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS', 'color' => 'success']);
    }

    // protecis fijas removibles
    public function fijasAux(Request $data)
    {

        $protesis = ProtesisFija::where('paciente_id', $data->id_paciente)
            ->where('piezas', $data->pieza)
            ->first();
        return $protesis;
    }

    public function fijaSave(Request $data)
    {
        $protesis = ProtesisFija::where('paciente_id', $data->id)
            ->where('hoja', $data->hoja)
            ->first();
        $protesis->piezas = $data->piezas;
        $protesis->fecha1 = $data->fecha1;
        $protesis->fecha2 = $data->fecha2;
        $protesis->fecha3 = $data->fecha3;
        $protesis->fecha4 = $data->fecha4;
        $protesis->fecha5 = $data->fecha5;
        $protesis->fecha6 = $data->fecha6;
        $protesis->fecha7 = $data->fecha7;
        $protesis->fecha8 = $data->fecha8;
        $protesis->fecha9 = $data->fecha9;
        $protesis->fecha10 = $data->fecha10;
        $protesis->doc1 = $data->doc1;
        $protesis->doc2 = $data->doc2;
        $protesis->doc3 = $data->doc3;
        $protesis->doc4 = $data->doc4;
        $protesis->doc5 = $data->doc5;
        $protesis->doc6 = $data->doc6;
        $protesis->doc7 = $data->doc7;
        $protesis->doc8 = $data->doc8;
        $protesis->doc9 = $data->doc9;
        $protesis->doc10 = $data->doc10;
        $protesis->cortes = $data->cortes;
        $protesis->cementadocon = $data->cementado;
        $protesis->cementarios = $data->obserCement;
        $protesis->tecnicautilizada = $data->tecImpre;
        $protesis->pruebametal = $data->pruMetal;
        $protesis->espesor3mm = $data->espesorMetla;
        $protesis->bizcocho = $data->bizcocho;
        $protesis->colorpieza = $data->colorPiezas;
        $protesis->pontico = $data->pontico;
        $protesis->pre_cementado = $data->precemtado;
        $protesis->e_exceso = $data->excesos;
        $protesis->cementadadocon2 = $data->cementadocon;
        $protesis->observaciones = $data->observacionesFinal;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS']);
    }

    // protesis removibles auxiliares
    public function removibleSave(Request $data)
    {
        $protesis = ProtesisRemovible::where('id',$data->id_pro)
            ->first();
        $protesis->superior =  $data->superior;
        $protesis->inferior = $data->inferior;
        $protesis->fecha1 = $data->fecha1;
        $protesis->fecha2 = $data->fecha2;
        $protesis->fecha3 = $data->fecha3;
        $protesis->fecha4 = $data->fecha4;
        $protesis->fecha5 = $data->fecha5;
        $protesis->fecha6 = $data->fecha6;
        $protesis->fecha7 = $data->fecha7;
        $protesis->fecha8 = $data->fecha8;
        $protesis->fecha9 = $data->fecha9;
        $protesis->fecha10 = $data->fecha10;
        $protesis->fecha11 = $data->fecha11;
        $protesis->fecha12 = $data->fecha12;
        $protesis->fecha13 = $data->fecha13;
        $protesis->fecha14 = $data->fecha14;
        $protesis->fecha15 = $data->fecha15;
        $protesis->doc1 = $data->doc1;
        $protesis->doc2 = $data->doc2;
        $protesis->doc3 = $data->doc3;
        $protesis->doc4 = $data->doc4;
        $protesis->doc5 = $data->doc5;
        $protesis->doc6 = $data->doc6;
        $protesis->doc7 = $data->doc7;
        $protesis->doc8 = $data->doc8;
        $protesis->doc9 = $data->doc9;
        $protesis->doc10 = $data->doc10;
        $protesis->doc11 = $data->doc11;
        $protesis->doc12 = $data->doc12;
        $protesis->doc13 = $data->doc13;
        $protesis->doc14 = $data->doc14;
        $protesis->doc15 = $data->doc15;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS']);
    }

    public function removibleAux(Request $data)
    {
        $protesis = ProtesisRemovible::where('paciente_id', $data->id_paciente)
            ->where('superior', $data->pieza)
            ->orwhere('inferior', $data->pieza)
            ->first();
        return $protesis;
    }

    // para crear hojas desde la vista show pacientes
    public function removibleNew(Request $data)
    {
        $protesis = new ProtesisRemovible();
        $protesis->superior =  $data->superior23;
        $protesis->inferior = $data->inferior23;
        $protesis->paciente_id = $data->id;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS', 'color' => 'success']);
    }

    public function fijasSaveNew(Request $data)
    {
        $protesis = new ProtesisFija();
        $protesis->piezas =  $data->pieza;
        $protesis->paciente_id = $data->id;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS', 'color' => 'success']);
    }

    public function endoSaveNew(Request $data)
    {
        $protesis = new Protesis_3();
        $protesis->pieza =  $data->pieza;
        $protesis->fecha = date('Y-m-d');
        $protesis->paciente_id = $data->id;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS', 'color' => 'success']);
    }

    public function totalNewSave(Request $data)
    {
        $protesis = new ProtesisTotal();
        $protesis->superior =  $data->superior23;
        $protesis->inferior = $data->inferior23;
        $protesis->paciente_id = $data->id;
        $protesis->save();
        return back()->with(['info' => 'DATOS ACTUALIZADOS', 'color' => 'success']);
    }
}
