<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DeudaPaciente;
use App\Models\DiarioPaciente;
use App\Models\Doctor;
use App\Models\Insumo;
use App\Models\Paciente;
use App\Models\PagoDoctor;
use App\Models\Procedimiento;
use App\Models\Tratamiento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PHPUnit\Framework\Constraint\Count;

class PresupuestoController extends Controller
{

    // gaurda asigan el presupuesto para  los pacientes0
    public function store(Request $request)
    {

        if (!$request->hoja) return back()->with(['info' => 'El Dato de la hoja es requerido', 'color' => 'warning']);


        if (!isset($request->tratamiento_id)) return back()->with(['info' => 'Debe Ingresar Almenos un tratamiento', 'color' => 'warning']);


        // dd($request->all());
        for ($i = 0; $i < count($request->tratamiento_id); $i++) {
            $pre = new  Procedimiento();
            $pre->pieza = $request->pieza[$i];
            $pre->tratamiento_id = $request->tratamiento_id[$i];
            $pre->valor = $request->subtotal[$i];
            $pre->paciente_id = $request->paciente_id;
            $pre->doctor_id =  1;
            $pre->estado_pago = false;
            $pre->hoja = $request->hoja;
            $pre->user_id = Auth::user()->id;
            $pre->save();
        }

        storeControl('registro un nuevo presupuesto para pacientes');


        return back()->with(['info' => 'Presupuesto Actualizado', 'color' => 'success']);
    }

    // elimina un dato del presupuesto
    public function delete($id)
    {
        Procedimiento::findOrFail($id)->delete();
        storeControl('elimino un registro de presupuesto para pacientes');

        return back()->with(['info' => 'Dato de Presupuesto Eliminado con Exito', 'color' => 'success']);
    }

    //  para imprimir la hoja de Presupuesto
    public function pritPresupuesto(Request $request,  $id)
    {

        // dd($request->hoja);
        $presupuestos = DB::table('procedimientos as pre')
            ->join('tratamientos as tr', 'pre.tratamiento_id', '=', 'tr.id')
            ->select('tr.nombre', 'tr.descripcion', 'tr.tipo', 'pre.pieza', 'pre.valor', 'pre.created_at as fecha', 'pre.valor', 'pre.id', 'tr.id as tratamiento_id', 'pre.deleted_at')
            ->where('pre.paciente_id', $id)
            ->where('pre.hoja', $request->hoja)
            ->orderBy('pre.pieza', 'DESC')
            ->get();
        $paciente = Paciente::findOrFail($id);
        $trata = Tratamiento::all();

        return view('reports.pacientes.presupuesto', ['presupuestos' => $presupuestos, 'paciente' => $paciente, 'tratamientos' => $trata]);
    }

    // IMPRIME EL  HISTORIAL DE LOS PACIENTES PARA HACER PAGO A LOS DOCTORES
    public function procedimientosPrint(Request $request, $id)
    {
        $procedimientos = DB::table('procedimientos as pro')
            ->join('tratamientos as tr', 'pro.tratamiento_id', '=', 'tr.id')
            ->join('doctores as doc', 'pro.doctor_id', '=', 'doc.id')
            ->leftjoin('users as us', 'pro.user_id', '=', 'us.id')
            ->select(
                'tr.nombre as tratamiento',
                'tr.descripcion',
                'tr.tipo',
                'tr.id as trId',
                'tr.tipo3', // sirve para ver si se debe sacar insumos
                'doc.nombre',
                'doc.id as doctorId',
                'pro.pieza',
                'pro.valor',
                'pro.created_at as fecha',
                'pro.estado_pago as estado',
                'pro.fecha as fecha_realizacion',
                'pro.id',
                'pro.deleted_at',
                'pro.asistio',
                'pro.recomendacion',
                'us.name',
                'pro.bloqueo',
            )
            ->where('pro.paciente_id', $id)
            ->where('pro.hoja', $request->hoja)
            ->orderBy('pro.id', 'asc')
            ->get();
        $paciente = Paciente::findOrFail($id);

        $doctores = Doctor::all();

        $insumos = Insumo::all();

        $diario = [];
        if ($request->hoja == '11') {
            $diario = DiarioPaciente::where('paciente_id', $id)
                ->where('hoja', $request->hoja)
                ->orderBy('id', 'desc')
                ->get();
        }


        // dd($request->hoja);
        // dd($procedimientos);

        return view('reports.pacientes.procedimientos', ['procedimientos' => $procedimientos, 'paciente' => $paciente, 'doctores' => $doctores, 'insumos' => $insumos, 'hoja' => $request->hoja, 'diario' => $diario]);
    }

    //asigna el pago a los doctores e hitorial de Tratamientos a los Pacientes y deuda para pacientes
    public function setProcedimientoAndPago(Request $request)
    {
        //actualizamos el procedimiento para que pueda ser visible el docotor que opero y se asigne la fecha de realizacion
        $presu = Procedimiento::find($request->procedimiento_id);
        $presu->doctor_id = $request->doctor_id;
        $presu->estado_pago = true;
        $presu->fecha = date('Y-m-d');
        $presu->asistio = Auth::user()->name;
        $presu->bloqueo = 'NO';

        // asignamos el pago a los docotores que brindara a los pacientes un historial
        $pago = new PagoDoctor();
        $pago->doctor_id = $request->doctor_id;
        $pago->paciente_id = $request->paciente_id;
        $pago->tratamiento_id = $request->tratamiento_id;
        $pago->pieza = $request->pieza;

        // asiganamos listado de  deuda para los pacientes
        $deuda = new DeudaPaciente();
        $deuda->paciente_id = $request->paciente_id;
        $deuda->doctor_id = $request->doctor_id;
        $deuda->tratamiento_id = $request->tratamiento_id;
        $deuda->pieza = $request->pieza;
        $trata = Tratamiento::find($request->tratamiento_id);
        if ($trata->tipo === 'PRIVADO' || $trata->tipo === 'REFERIDO') {
            $deuda->valor = $presu->valor;
            // asignamos deuda toltal para los pacientes; para despue comprobar si es un deudor
            $paciente = Paciente::find($request->paciente_id);
            $paciente->deuda = $paciente->deuda + $deuda->valor;
            $paciente->save();
        }

        $deuda->save();
        $pago->save();
        $presu->save();

        storeControl('registro procedimiento realizado a pacientes / pago de doctor');


        storeControl('registro tratamiento realizado a pacientes / pago de doctor');
        return back()->with(['info' => 'procedimiento actualizado con existo', 'color' => 'success']);
    }


    // elimina el pago a los docotres e hsitorla de tratamiento a los pacientes
    public function deleteProcedimientoAndPago(Request $request)
    {

        //actualizamos el procedimiento para que pueda ser visible el docotor que opero y se asigne la fecha de realizacion

        $presu = Procedimiento::find($request->procedimiento_id);
        $presu->doctor_id = 1;
        $presu->estado_pago = false;
        $presu->fecha = null;
        $presu->asistio = null;
        $presu->recomendacion = null;
        $presu->bloqueo = null;
        // asignamos el pago a los docotores que brindara a los pacientes un historial
        $pago = PagoDoctor::where('doctor_id', $request->doctor_id)
            ->where('paciente_id', $request->paciente_id)
            ->where('tratamiento_id', $request->tratamiento_id)
            ->where('pieza',  $request->pieza)
            ->first();

        $deuda = DeudaPaciente::where('doctor_id', $request->doctor_id)
            ->where('paciente_id', $request->paciente_id)
            ->where('tratamiento_id', $request->tratamiento_id)
            ->where('pieza',  $request->pieza)
            ->first();

        // eliminamos el pago de la deuda de un paciente para corroborara sus deudas

        $paciente = Paciente::find($request->paciente_id);
        $paciente->deuda = $paciente->deuda - $deuda->valor;



        $paciente->save();
        $pago->delete();
        $deuda->delete();
        $presu->save();
        storeControl('elimino tratamiento realizado a pacientes / pago de doctor');


        return back()->with(['info' => 'procedimiento actualizado con existo', 'color' => 'warning']);
    }

    // permite Copyrightpoder actualizar los  datos de un procedimiento
    public function updatePresupuesto(Request $request)
    {
        $data = Procedimiento::findOrFail($request->id);
        $trata = Tratamiento::findOrFail($request->tratamiento_id);

        $data->pieza = $request->pieza;
        $data->valor = $trata->precio;
        $data->tratamiento_id = $trata->id;

        $data->save();

        return back()->with(['info' => 'DATOS ACTUALIZADOS CON EXITO', 'color' => 'success']);
    }


    // retorna la nueva vista para asignacion de datos al presupuesto
    public function new_presu($id)
    {
        $tratamientos = Tratamiento::all();
        return view('admin.pacientes.data.new_presupuesto', ['data' => $tratamientos, 'id' => $id]);
    }

    function getTratamientoAjax(Request $request)
    {

        $data = Tratamiento::where('nombre', 'LIKE', '%' .  $request->codigo . '%')
            ->orwhere('descripcion', 'LIKE', '%' .  $request->codigo . '%')
            ->get();

        return response($data);
    }

    // agrupa los datos del presupuesto
    public function agurpar_presupuesto(Request $request, $id)
    {
        $data = DB::table('procedimientos as p')
            ->join('tratamientos as t', 'p.tratamiento_id', '=', 't.id')
            ->select('t.nombre', 't.descripcion', 'p.valor', DB::raw('COUNT(p.tratamiento_id) as numero '),)
            ->groupBy('t.id')
            ->where('p.paciente_id', '=', $id)
            ->where('p.hoja', $request->hoja)
            ->where('p.deleted_at', null)
            ->get();
        $paciente = Paciente::find($id);
        return view('reports.pacientes.procedimiento_agrupado', ['data' => $data, 'paciente' => $paciente]);
    }

    // retona los procedimientos eliminados a no elimindos
    public function restore($id)
    {
        $pres = Procedimiento::withTrashed()->find($id);

        $pres->restore();
        return back()->with(['info' => 'Dato de Presupuesto Eliminado con Exito', 'color' => 'success']);
    }
}
