<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Paciente;
use App\Models\PeriodontogramaPaciente;
use Illuminate\Http\Request;

class PeriodontogramaController extends Controller
{


    public function index($id)
    {
        $perio = PeriodontogramaPaciente::where('paciente_id', $id)->get();
        $paciente = Paciente::findOrFail($id);
        return view('reports.pacientes.periodontograma', ['data' => $perio, 'paciente' => $paciente]);
    }

    public function store(Request $request)
    {

        if ($request->hasFile("documento")) {
            $pe = new PeriodontogramaPaciente();
            $pe->paciente_id = $request->paciente_id;
            $file = $request->file('documento');

            $nombre = time() . $file->getClientOriginalName();

            $file->move(storage_path() . '/app/public/paciente/periodonto', $nombre);
            $pe->documento = $nombre;
        }


    
        $pe->save();

        return back()->with(['info' => 'periodontograma asignado con exito', 'color' => 'success']);
    }
}
