<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Doctor;
use App\Models\PagoTratamiento;
use App\Models\Tratamiento;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class PagoTratamientoController extends Controller
{

    public function index()
    {
        abort_if(Gate::denies('pagodoctor_listado'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $pagos = DB::table('pago_tratamientos as pg')
            ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
            ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
            ->select('doc.nombre as doctor', 'tr.tipo', 'tr.nombre as tratamiento', 'tr.precio', 'pg.porcentaje', 'pg.id', 'pg.monto')
            ->where('tr.deleted_at', null)
            ->get();

        return view('admin.pagos.index', ['pagos' => $pagos]);
    }

    public function create()
    {
        abort_if(Gate::denies('pagodoctor_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $tratamientos = Tratamiento::all();
        $doctores = Doctor::all();
        return view('admin.pagos.create', ['tratamientos' => $tratamientos, 'doctores' => $doctores]);
    }

    public function store(Request $request)
    {
        abort_if(Gate::denies('pagodoctor_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $vueltas = count($request->tratamiento_id);
        // dd($vueltas);

        // dd($request->all());

        if (
            $request->porcentaje > 0 && $request->monto > 0
        ) {
            return back()->with(['info' => 'Debe Ingresar Procentaje o Monto NO AMBOS', 'color' => 'warning']);
        }


        for ($i = 0; $i < $vueltas; $i++) {
            $pago = new PagoTratamiento();
            $pago->doctor_id = $request->doctor_id;
            $pago->tratamiento_id = $request->tratamiento_id[$i];
            $pago->porcentaje = $request->porcentaje;
            $pago->monto = $request->monto;
            $pago->save();
        }

        storeControl('registro porcentajes de pago a doctores');

        return back()->with(['info' => 'Pago Metodo de Pago Asignado Con Exito', 'color' => 'success']);
    }

    public function show($id)
    {
        //
        abort_if(Gate::denies('pagodoctor_update'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $pago = DB::table('pago_tratamientos as pg')
            ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
            ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
            ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
            ->where('pg.id', $id)
            ->first();

        $pagoDoctor = ($pago->precio * $pago->porcentaje) / 100;
        $gananciaClinica = $pago->precio - $pagoDoctor;

        return view('admin.pagos.show', ['pago' => $pago, 'pagoDoctor' => $pagoDoctor, 'gananciaClinica' => $gananciaClinica]);
    }

    public function update(Request $request, $id)
    {
        //
        abort_if(Gate::denies('pagodoctor_update'), Response::HTTP_FORBIDDEN, 'Forbidden');

        PagoTratamiento::find($id)->update($request->all());
        return back()->with(['info' => 'Pago Actualizado', 'color' => 'warning']);
    }

    public function destroy($id)
    {
        abort_if(Gate::denies('pagodoctor_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');

        PagoTratamiento::find($id)->delete();
        return back()->with(['info' => 'Pago de Porcentaje Eliminado con Exito', 'color' => 'warning']);
    }

    // retorna el listado de porcentaje de pagos para todos los doctore
    public function reportPagos()
    {

        abort_if(Gate::denies('pagodoctor_report'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $pagos = DB::table('pago_tratamientos as pg')
            ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
            ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
            ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
            ->get();
        return view('reports.tratamientos.pagos', ['pagos' => $pagos, 'titulo' => 'Porcentajes de Pago y Ganancias',  'visible' => true]);
    }

    // retorna un listado de porcentajes de pago para un doctor
    public function reportPagoDocto($id)
    {
        abort_if(Gate::denies('pagodoctor_report'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $pagos = DB::table('pago_tratamientos as pg')
            ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
            ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
            ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
            ->where('doc.id', $id)
            ->get();

        return view('reports.tratamientos.pagos', ['pagos' => $pagos, 'titulo' => 'Pagos Doctor', 'visible' => false]);
    }
}
