<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PagoFactura;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class PagoFacturaController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('pagosfactura_listado'), Response::HTTP_FORBIDDEN, 'Forbidden');
        return view('admin.facturas.index', ['facturas' => PagoFactura::orderBy('fecha_pago', 'desc')->get()]);
    }

    public function store(Request $request)
    {
        abort_if(Gate::denies('pagosfactura_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        PagoFactura::create($request->all());
        return back()->with(['info' => 'pago de facura registrada con exito', 'color' => 'success']);
    }

    public function destroy($id)
    {
        abort_if(Gate::denies('pagosfactura_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');
        PagoFactura::find($id)->delete();
        return back()->with(['info' => 'pago de facura eliminado con exito', 'color' => 'danger']);
    }

    public function reporte()
    {
        abort_if(Gate::denies('pagosfactura_report'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $factura = PagoFactura::orderBy('id',  'desc')->get();
        return view('reports.facturas.pagos', ['facturas' => $factura]);
    }
}
