<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Abono;
use App\Models\DeudaMeciamento;
use App\Models\DeudaPaciente;
use App\Models\DiarioPaciente;
use App\Models\Paciente;
use App\Models\Procedimiento;
use App\Models\Protesis_3;
use App\Models\ProtesisFija;
use App\Models\ProtesisRemovible;
use App\Models\ProtesisTotal;
use App\Models\RecordatorioPaciente;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str; // Necesario para Str::random()


class PacienteController extends Controller
{

    public function index()
    {
        abort_if(Gate::denies('paciente_listado'), Response::HTTP_FORBIDDEN, 'Forbidden');
        return view('admin.pacientes.index');
    }

    /*************  ✨ Windsurf Command ⭐  *************/
    /**
     * Returns a JSON response with the list of patients.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    /*******  b8eaf5dc-a6e7-43be-967d-91074a765107  *******/
    function getAjaxPaciente(Request $request)
    {
        if ($request->ajax()) {
            $articulos = Paciente::select(['id', 'nombre', 'dpi', 'telefono', 'direccion', 'tipo', 'aut9']);
            return DataTables::of($articulos)->make(true);
        }
    }


    public function create()
    {
        return view('admin.pacientes.create');
    }


    public function store(Request $request)
    {

        $paciente = new Paciente($request->all());
        $paciente->save();

        storeControl('registro a un paciente');

        return back()->with(['info' => 'Paciente Registrado con Exito', 'color' => 'success']);
    }

    public function edit(Request $request, $id)
    {
        $paciente = Paciente::findOrFail($id);
        return view('admin.pacientes.edit', ['paciente' => $paciente]);
    }

    // retorna la vista para registrar pacientes por tipo
    public function registroTablet()
    {
        return view('admin.pacientes.registrotablet');
    }

    // retorna la vista para registrar pacientes diel igss
    public function registroIgss()
    {
        return view('admin.pacientes.tablet.igss');
    }

    // guarda un paciente registrado desde la table siento del igss
    public function registroIgssStore(Request $request)
    {
        $paciente = new Paciente($request->all());
        $paciente->save();
        return back()->with(['info' => 'Paciente Registrado con Exito', 'color' => 'success']);
    }

    // retorna la vista para registrar pacientes privados
    public function registroPrivado()
    {
        return view('admin.pacientes.tablet.privado');
    }

    public function registroPrivadoStore(Request $request)
    {
        $paciente = new Paciente($request->all());
        // Guardamos primero para tener el ID si fuera necesario, aunque aquí no afecta
        $paciente->save();

        // ---------------------------------------------------------
        // 1. FIRMA (ARCHIVO O CANVAS)
        // ---------------------------------------------------------

        // A) Si subió archivo
        if ($request->hasFile('firma2')) {
            $file = $request->file('firma2');
            $nombreFirma = time() . '_' . $file->getClientOriginalName();

            // ESTA ES LA MEJOR FORMA:
            // $file->storeAs(Carpeta, Nombre, Disco);
            $file->storeAs('paciente/firmas', $nombreFirma, 'public');

            $paciente->firma2 = $nombreFirma;
            $paciente->save();
        }
        // B) Si dibujó en el Canvas (Base64)
        else if ($request->filled('firma_base64')) {
            $base64_image = $request->input('firma_base64');

            if (preg_match('/^data:image\/(\w+);base64,/', $base64_image)) {
                $data = substr($base64_image, strpos($base64_image, ',') + 1);
                $data = base64_decode($data);

                $nombreFirma = time() . '_firma_canvas.png';

                // CORRECCIÓN PRINCIPAL AQUÍ:
                // Usamos Storage::disk('public')->put().
                // Si la carpeta 'paciente/firmas' no existe, Laravel la crea sola.
                Storage::disk('public')->put('paciente/firmas/' . $nombreFirma, $data);

                $paciente->firma2 = $nombreFirma;
                $paciente->save();
            }
        }

        // ---------------------------------------------------------
        // 2. FOTO DE WEBCAM (Base64)
        // ---------------------------------------------------------
        if ($request->filled('webcam_image')) {
            $webcamImageData = $request->input('webcam_image');

            // Verificar que no venga vacío o null
            if (!empty($webcamImageData)) {
                // Eliminar prefijo si tienes la función, si no, usar regex simple
                // $base64Image = $this->removeDataUriPrefix($webcamImageData);

                // Limpieza manual rápida por si acaso no tienes la función helper a mano:
                $base64Image = preg_replace('/^data:image\/\w+;base64,/', '', $webcamImageData);

                $decodedImage = base64_decode($base64Image);

                if ($decodedImage !== false) {
                    $imageName = date('ymdhis') . '_' . Str::random(10) . '.png';
                    $storageFolder = 'pacientes/fotos/';

                    try {
                        // Esto ya estaba bien, usa Storage
                        Storage::disk('public')->put($storageFolder . $imageName, $decodedImage);

                        $paciente->foto_perfil = $imageName;
                        $paciente->save();
                    } catch (\Exception $e) {
                        // Loguear el error es buena práctica
                        throw $e;
                    }
                }
            }
        }

        storeControl('registro a un paciente');

        return back()->with(['info' => 'Paciente Registrado con Exito', 'color' => 'success']);
    }


    public function show($id)
    {
        abort_if(Gate::denies('paciente_perfil'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $paciente = Paciente::findOrFail($id);
        $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
        // $tratamientos = Tratamiento::all();
        $historial = $this->getTratamiento($id);
        $totalDeuda = $this->getTotalDeuda($id);
        $totalAbonado = $this->getTotalAbono($id);
        // 'tratamientos' => $tratamientos,

        $removibles = ProtesisRemovible::where('paciente_id', $id)
            ->get();

        $fijas = ProtesisFija::where('paciente_id', $id)
            ->get();

        $endodoncia =  Protesis_3::where('paciente_id', $id)
            ->get();

        $pro_total = ProtesisTotal::where('paciente_id', $id)
            ->get();

        $diario = DiarioPaciente::where('paciente_id', $id)->orderBy('id', 'desc')->get();



        return view(
            'admin.pacientes.show',
            [
                'paciente' => $paciente,
                'edad' => $edad,
                'historial' => $historial,
                'totalDeuda' => $totalDeuda,
                'totalAbonado' => $totalAbonado,
                'removible' => $removibles,
                'fijas' => $fijas,
                'endo' => $endodoncia,
                'pro_total' => $pro_total,
                'diario' => $diario

            ]
        );
    }

    public function update(Request $request, Paciente $paciente)
    {

        $this->auxiliar_edit($request);

        $paciente->e1 = $request->e1;
        $paciente->e2 = $request->e2;
        $paciente->e3 = $request->e3;
        $paciente->e4 = $request->e4;
        $paciente->e5 = $request->e5;
        $paciente->e6 = $request->e6;
        $paciente->e7 = $request->e7;
        $paciente->e8 = $request->e8;
        $paciente->e9 = $request->e9;
        $paciente->e10 = $request->e10;
        $paciente->e11 = $request->e11;
        $paciente->e12 = $request->e12;
        $paciente->e13 = $request->e13;
        $paciente->e14 = $request->e14;
        $paciente->e15 = $request->e15;
        $paciente->e16 = $request->e16;
        $paciente->e17 = $request->e17;
        $paciente->e18 = $request->e18;
        $paciente->e19 = $request->e19;
        $paciente->e20 = $request->e20;
        $paciente->e21 = $request->e21;
        $paciente->e22 = $request->e22;
        $paciente->e23 = $request->e23;
        $paciente->e24 = $request->e24;
        $paciente->e25 = $request->e25;
        $paciente->e26 = $request->e26;
        $paciente->e27 = $request->e27;
        $paciente->e28 = $request->e28;
        $paciente->e29 = $request->e29;
        $paciente->e30 = $request->e30;
        $paciente->e31 = $request->e31;
        $paciente->e32 = $request->e32;
        $paciente->e33 = $request->e33;
        $paciente->e34 = $request->e34;
        $paciente->e35 = $request->e35;
        $paciente->e36 = $request->e36;
        $paciente->e37 = $request->e37;
        $paciente->e38 = $request->e38;
        $paciente->e39 = $request->e39;
        $paciente->e40 = $request->e40;
        $paciente->au1 = $request->au1;
        $paciente->au2 = $request->au2;
        $paciente->au3 = $request->au3;
        $paciente->au4 = $request->au4;
        $paciente->au5 = $request->au5;
        $paciente->au6 = $request->au6;
        $paciente->au7 = $request->au7;
        $paciente->au8 = $request->au8;
        $paciente->au9 = $request->au9;

        $paciente->update($request->all());





        // 2. Obtener y Procesar la Imagen Base64
        $webcamImageData = $request->input('webcam_image');

        // Eliminar el prefijo data URI
        $base64Image = $this->removeDataUriPrefix($webcamImageData);

        // Decodificar la imagen Base64
        $decodedImage = base64_decode($base64Image);

        // Verificar si la decodificación fue exitosa
        if ($decodedImage === false) {
            return redirect()->back()->withInput()->withErrors(['webcam_image' => 'Formato de imagen inválido.']);
        }

        // 3. Configurar el Nombre del Archivo y la Ruta de Almacenamiento
        // Generar un nombre único (puedes usar el formato de fecha que preferías)
        $imageName = date('ymdhis') . '_' . Str::random(10) . '.png'; // Añadimos un random para más seguridad
        $storageFolder = 'pacientes/fotos/'; // Carpeta dentro del disco 'public'


        // 4. Guardar la Imagen usando Storage
        try {
            // Guardar en storage/app/public/pacientes/nombre_imagen.png
            $data = Storage::disk('public')->put($storageFolder . '' . $imageName, $decodedImage);


            // Suponiendo que ya tienes tu objeto $paciente listo:
            $paciente->foto_perfil = $imageName; // Guarda la ruta interna
            // O $paciente->foto_perfil = $publicUrl; // Si prefieres guardar la URL pública

            $paciente->save(); // Guarda el modelo
            // dd($imageName, $storageFolder, $data, $paciente);
        } catch (\Exception $e) {
        }


        // 6. Procesar los Otros Datos del Formulario
        // ... guarda otros datos en $paciente si aplica ...
        // $paciente->save();



        // dd($paciente);

        return back()->with(['info' => 'Datos del Paciente Actualizado', 'color' => 'warning']);
    }

    /**
     * Helper para eliminar el prefijo data URI (ej: data:image/png;base64,)
     *
     * @param string $dataUri
     * @return string
     */
    private function removeDataUriPrefix($dataUri)
    {
        // Verifica si la cadena comienza con "data:image/"
        if (Str::startsWith($dataUri, 'data:image/')) {
            // Busca el primer ";"
            $semiColonPosition = strpos($dataUri, ';');
            if ($semiColonPosition !== false) {
                // Busca la primera "," después del ";"
                $commaPosition = strpos($dataUri, ',', $semiColonPosition);
                if ($commaPosition !== false) {
                    return substr($dataUri, $commaPosition + 1); // +1 para saltar la ","
                }
            }
        }
        return $dataUri; // Si no tiene el formato esperado, la devuelve tal cual
    }


    public function destroy($id)
    {
        abort_if(Gate::denies('paciente_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');
        Paciente::find($id)->delete();
        storeControl('elimino a un paciente');

        return back()->with(['info' => 'PACIENTE ELIMINADO CON EXITO', 'color' => 'success']);
    }

    // funcion opcional
    public function auxiliar_edit(Request $r)
    {
        $nuevasEntradas = [];
        for ($i = 1; $i <= 40; $i++) {
            $propiedad = 'e' . $i;
            $nuevasEntradas[$propiedad] = (is_null($r->input($propiedad))) ? 'false' : 'true';
        }

        for ($i = 1; $i <= 9; $i++) {
            $propiedad = 'au' . $i;
            $nuevasEntradas[$propiedad] = (is_null($r->input($propiedad))) ? 'false' : 'true';
        }

        $r->merge($nuevasEntradas);
        return $r;
    }

    // retorna la vista de los  pacientes activos
    public function pacientesActivos()
    {
        $paciente =  $this->pacientesEstado('ACTIVO');
        return view('admin.pacientes.estados', ['pacientes' => $paciente, 'estado' => 'ACTIVOS']);
    }

    // retorna la vista de pacientes inactivos
    public function pacientesInactivos()
    {
        $paciente = Paciente::where('updated_at', '<', Carbon::now()->subMonths(6))->get();
        return view('admin.pacientes.estados', ['pacientes' => $paciente, 'estado' => 'INACTIVOS']);
    }

    // retorna la vista para generar reporte de los pacientes
    public function reportes()
    {
        return view('admin.pacientes.reportes');
    }

    // retorna el reporte de los pacientes activos
    public function reportActivos()
    {
        $pacientes = $this->pacientesEstado('ACTIVO');

        return view('reports.pacientes.estado', ['pacientes' => $pacientes, 'estado' => 'ACTIVOS']);
    }

    // retorna el reporte de los pacientes activos
    public function reportInactivos()
    {
        $pacientes = $this->pacientesEstado('INACTIVO');
        return view('reports.pacientes.estado', ['pacientes' => $pacientes, 'estado' => 'INACTIVO']);
    }

    // retorna el reporte de los pacientes activos
    public function reportall()
    {
        $pacientes = Paciente::orderBy('nombre', 'asc')->get();
        return view('reports.pacientes.estado', ['pacientes' => $pacientes, 'estado' => '']);
    }

    // retorna los pacientes con unestado especifico
    public function pacientesEstado($estado = 'ACTIVO')
    {
        return Paciente::where('estado', $estado)->get();
    }

    // retorna el Historial de Tratamientos de cada paciente
    public function getTratamiento($id)
    {
        return DB::table('pago_docotores as pd')
            ->join('tratamientos as tr', 'pd.tratamiento_id', '=', 'tr.id')
            ->join('doctores as dc', 'pd.doctor_id', '=', 'dc.id')
            ->select(
                'pd.pieza',
                'tr.nombre as tratamiento',
                'tr.descripcion as descripcionTr',
                'tr.tipo',
                'dc.nombre',
                'pd.created_at'
            )
            ->where('pd.paciente_id', $id)
            ->orderBy('pd.id', 'desc')
            ->get();
    }

    // retorna las deudas de los pacientes
    public function getDeuda($id)
    {
        return  DeudaPaciente::where('paciente_id', $id)->get();
    }

    // retorna el total de deuda de Pacientes
    public function getTotalDeuda($id)
    {
        $deudas = $this->getDeuda($id);
        $totalDeuda = 0;
        foreach ($deudas as $deuda) {
            $totalDeuda += $deuda->valor;
        }
        return $totalDeuda;
    }

    // retorna el total Abonado de un paciente
    public function getTotalAbono($id)
    {
        $abonos = Abono::where('paciente_id', $id)->orderBy('id', 'desc')->get();
        $totalAbonos = 0;
        foreach ($abonos as $abono) {
            $totalAbonos += $abono->valor;
        }
        return $totalAbonos;
    }


    // Retorna la vista de deudores
    public function deudores()
    {
        $paciente = Paciente::select('nombre', 'ocupacion', 'telefono', 'ocupacion', 'telefono_en',  'direccion', 'abono', 'deuda', 'id', 'tipo')->get();
        $deudores = array();
        foreach ($paciente as $pac) {

            if ($pac->deuda > $pac->abono) {
                array_push($deudores, $pac);
            }
        }
        return view('admin.pacientes.deudores', ['pacientes' => $deudores]);
    }

    // permite imprimir la ficha Clinica de cada Pacientes
    public function printFicha($id)
    {
        $paciente = Paciente::findOrFail($id);
        $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
        return view('reports.pacientes.ficha_clinica', ['paciente' => $paciente, 'edad' => $edad]);
    }

    // imprime el reporte de deudores
    public function printDeudores()
    {

        $paciente = Paciente::select('nombre', 'ocupacion', 'telefono', 'direccion', 'abono', 'deuda', 'id', 'tipo')->get();
        $deudores = array();
        foreach ($paciente as $pac) {

            if ($pac->deuda > $pac->abono) {
                array_push($deudores, $pac);
            }
        }
        return view('reports.pacientes.deudores', ['pacientes' => $deudores]);
    }

    // ----------------------------
    //      DEUDA DE MEDICAMENTO
    // ----------------------------
    public function deudaMedicamentos($id)
    {
        $pendientes = DeudaMeciamento::where('paciente_id', $id)->get();

        $data = Paciente::find($id)->nombre;

        return view('reports.pacientes.deudamedicamento', ['paciente' => $id, 'pendientes' => $pendientes,  'nombre' => $data]);
    }

    public function storeDeudaMedicamento(Request $request)
    {
        DeudaMeciamento::create($request->all());

        return back()->with(['info' => 'DEUDA ASIGNADA', 'color' => 'success']);
    }

    public function deleteDeudaMedicamento($id)
    {
        DeudaMeciamento::find($id)->delete();
        return back()->with(['info' => 'DEUDA CANCELADA CON EXITO', 'color' => 'success']);
    }

    // GUARDA LA FIRMA DE UN PACIENTE
    public function setFirma(Request $request)
    {
        if ($request->hasFile('firma')) {
            $paciente = Paciente::findOrFail($request->paciente_id);
            $file = $request->file('firma');
            $nombre = time() . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/paciente/firmas', $nombre);
            $paciente->firma = $nombre;
            $paciente->save();


            return back()->with(['info' => 'firma asignada', 'color' => 'success']);
        } else {
            return back()->with(['info' => 'firma no asignada', 'color' => 'danger']);
        }
    }

    // permite re-registrar una firma copiando el nombre de fiema asi otro campo
    public function setReFirma($id)
    {
        $paciente = Paciente::find($id);

        $firma = $paciente->firma;
        $firma2 = $paciente->firma2;

        if (!$firma) {
            $paciente->firma = $firma2;
        }

        if (!$firma2) {
            $paciente->firma2 = $firma;
        }

        if (!$firma && !$firma2) {
            return back()->with(['info' => 'NO SE HA SUBIDO NINGUNA FIRMA ANTERIOR', 'color' => 'danger']);
        }

        $paciente->save();

        return back()->with(['info' => 'FIRMAS ASIGNADAS', 'color' => 'success']);
    }

    // ------------ recordatorio

    // PERMITE GUARDATA UN RECORDATORIO PARA UN PACIENTE
    public function recordatorios($id)
    {
        $data = RecordatorioPaciente::where('paciente_id', $id)->get();
        $paciente = Paciente::find($id);
        return view('reports.pacientes.recordatorio', ['data' => $data, 'paciente' => $paciente]);
    }

    // PERMITE GUARDATA UN RECORDATORIO PARA UN PACIENTE
    public function recordatorio(Request $request)
    {
        RecordatorioPaciente::create($request->all());
        return back()->with(['info' => 'recordatorio guardado', 'color' => 'success']);
    }
    // PERMITE ELIMINAR UN RECORDATORIO PARA UN PACIENTE
    public function delete_recordatorio($id)
    {
        RecordatorioPaciente::findOrFail($id)->delete();
        return  back()->with(['info' => 'recordatorio eliminado', 'color' => 'success']);
    }


    // retorna los abonos realizados en un dia en concreto
    public function abono_dia()
    {

        $abonos = Abono::whereDate('created_at', date('Y-m-d'))->get();

        return view('reports.pacientes.abonos_dia', compact('abonos',));
    }
}
