<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Doctor;
use App\Models\Ortodoncia;
use App\Models\Paciente;
use App\Models\Salida;
use Illuminate\Http\Request;

class OrtodonciaController extends Controller
{
    // retona el apartado para poder registrar datos para ortodoncias
    public function index()
    {
        $doc = Doctor::all();
        $orto = Ortodoncia::whereDate('created_at', date('Y-m-d'))->get();
        $salida = Salida::whereDate('created_at', date('Y-m-d'))->get();
        return view('admin.ortodoncia.index', compact('orto', 'doc', 'salida'));
    }

    public function store(Request $request)
    {
        Ortodoncia::create($request->all());
        return back()->with(['info' => 'GUARDADO CON EXITO', 'color' => 'success']);
    }

    public function delete($id)
    {
        Ortodoncia::findOrFail($id)->delete();
        return back()->with(['info' =>  'ELIMINADO CON EXITO', 'color' => 'success']);
    }

    public function reportes()
    {
        $doc = Doctor::all();
        return view('admin.ortodoncia.report', compact('doc'));
    }

    // retorna la vista de pacientes operados por ortodoncia filtrados en una fecha en concreto
    public function paciente_orto_fecha(Request $request)
    {
        $orto =
            Ortodoncia::whereBetween('created_at', [$request->inicio, $request->final])
            ->get();
        return view('reports.ortodoncia.pacientes', compact('orto'));
    }

    // retorna la vista pago a doctores en ortodoncia
    public function doc_orto_fecha(Request $request)
    {
        $orto =
            Ortodoncia::where('doctor_id', $request->doctor_id)
            ->whereBetween('created_at', [$request->inicio, $request->final])
            ->get();
        return view('reports.ortodoncia.pacientes', compact('orto'));
    }

    // retorna el recibo de un abono 
    public function print_reciboo($id)
    {
        $ort = Ortodoncia::findOrFail($id);

        return view('reports.ortodoncia.recibo', compact('ort'));
    }

    // descuento de orto

    public function decuento_Orto(Request $request)
    {
        Salida::create($request->all());
        return back()->with(['info' => 'GUARDADO CON EXITO', 'color' => 'success']);
    }
}
