<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MobiliarioEquipo;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class MobiliarioEquipoController extends Controller
{

    public function index()
    {
        abort_if(Gate::denies('mobiliario_listado'), Response::HTTP_FORBIDDEN, 'Forbidden');

        return view('admin.mobiliario.index', ['mobiliarios' => MobiliarioEquipo::all()]);
    }

    public function create()
    {
        abort_if(Gate::denies('mobiliario_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        return view('admin.mobiliario.create');
    }

    public function store(Request $request)
    {
        abort_if(Gate::denies('mobiliario_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        MobiliarioEquipo::create($request->all());
        storeControl('registro un nuevo mobiliario y equipo');

        return back()->with(['info' => 'mobiliario registrado con exito', 'color' => 'success']);
    }

    public function show($id)
    {
        abort_if(Gate::denies('mobiliario_update'), Response::HTTP_FORBIDDEN, 'Forbidden');

        return view('admin.mobiliario.show', ['mobiliario' => MobiliarioEquipo::find($id)]);
    }



    public function update(Request $request, MobiliarioEquipo $mobiliario)
    {
        abort_if(Gate::denies('mobiliario_update'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $mobiliario = MobiliarioEquipo::find($request->id);
        $mobiliario->update($request->all());
        return back()->with(['info' => 'mobiliario actualizado con exito', 'color' => 'warning']);
    }

    public function destroy($id)
    {
        abort_if(Gate::denies('mobiliario_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');
        MobiliarioEquipo::find($id)->delete();
        storeControl('elimino de mobiliario y equipo');

        return back()->with(['info' => 'mobiliario eliminado con exito', 'color' => 'danger']);
    }

    public function reporte()
    {
        abort_if(Gate::denies('mobiliario_report'), Response::HTTP_FORBIDDEN, 'Forbidden');
        return view('reports.mobiliario.all', ['mobiliario' => MobiliarioEquipo::all()]);
    }
}
