<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Laboratorio;
use App\Models\PacienteLaboratorio;
use App\Models\ServiciosLaboratorio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LaboratorioController extends Controller
{

    public function index()
    {
        return view('admin.laboratorio.index', ['laboratorios' => Laboratorio::paginate(10)]);
    }

    public function create()
    {
        return view('admin.laboratorio.create');
    }

    public function store(Request $request)
    {
        Laboratorio::create($request->all());
        storeControl('registro un laboratorio');

        return back()->with(['info' => 'laboratorio registrado con exito', 'color' => 'success']);
    }

    public function destroy($id)
    {
        Laboratorio::find($id)->delete();
        storeControl('registro un laboratorio');

        return back()->with(['info' => 'laboratorio eliminado con exito', 'color' => 'success']);
    }

    public function show($id)
    {
        $laboratorio = Laboratorio::find($id);
        $servicios = ServiciosLaboratorio::where('laboratorio_id', $id)->get();

        return view('admin.laboratorio.show', ['laboratorio' => $laboratorio, 'servicios' => $servicios]);
    }


    // permite visualizar las beces que el paciente asistira un laboratorio
    public function paciente($id)
    {
        $paciente = DB::table('paciente_l_aboratorios as  pl')

            ->join('laboratorios as lab', 'pl.laboratorio_id', '=', 'lab.id')
            ->select('pl.total', 'pl.descripcion', 'pl.created_at', 'lab.nombre', 'pl.id')
            ->where('paciente_id', $id)
            ->get();

        $laboratorios = DB::table('servicios_laboratorios as servi')
            ->join('laboratorios as lab', 'servi.laboratorio_id', '=', 'lab.id')
            ->select('lab.nombre as laboratorio', 'lab.id as laboratorio_id', 'servi.nombre as servicio', 'servi.precio', 'servi.id as servicio_id')
            ->get();

        return view('reports.laboratorio.pacientes', ['pacientes' => $paciente, 'laboratorios' => $laboratorios, 'paciente_id' => $id]);
    }

    // PERMITE ASIGNAR EL TOTAL DE PAGO A LABORATORIO
    public function pacienteStore(Request $request)
    {
        // PacienteLaboratorio::create($request->all());

        $data = explode("_", $request->laboratorio_id);

        $servicio_id = $data[0];
        $laboratorio_id = $data[1];

        $servicio = ServiciosLaboratorio::find($servicio_id);

        $laboratorio = new PacienteLaboratorio();
        $laboratorio->paciente_id = $request->paciente_id;
        $laboratorio->laboratorio_id = $laboratorio_id;
        $laboratorio->total = $servicio->precio;
        $laboratorio->descripcion = "$servicio->nombre \n  PIEZA:  $request->pieza " . $request->descripcion;
        $laboratorio->save();

        return back()->with(['info' => 'pago asignado con exito', 'color' => 'success']);
    }

    // elimina el registro de un paciente en un laboratorio
    public function pacienteDelete($id)
    {
        PacienteLaboratorio::find($id)->delete();
        return back()->with(['info' => 'pago elimiando con exito', 'color' => 'success']);
    }

    // retorna la vista para los reporte de LABORATORIOS
    public function reportes()
    {
        $laboratorios = Laboratorio::all();
        return view('admin.laboratorio.reportes', ['laboratorios' => $laboratorios]);
    }

    // reporte para todos los laboratorios registrados
    public function reporteAll()
    {
        return view('reports.laboratorio.laboratorio', ['laboratorios' => Laboratorio::all()]);
    }

    // reporete de "deudas / pacientes registrados" en un laboratorio
    public function pacienteLaboratorio(Request $request)
    {
        $pacientes = DB::table('paciente_l_aboratorios as  pl')
            ->join('pacientes as pac', 'pl.paciente_id', '=', 'pac.id')
            ->join('laboratorios as lab', 'pl.laboratorio_id', '=', 'lab.id')
            ->select('pl.total', 'pl.descripcion', 'pl.created_at', 'lab.nombre', 'pl.id', 'pac.nombre as paciente')
            ->where('pl.laboratorio_id', $request->laboratorio_id)
            ->whereYear('pl.created_at', $request->ano)
            ->whereMonth('pl.created_at', $request->mes)
            ->get();

        return view('reports.laboratorio.pacientesLaboratorio', ['pacientes' => $pacientes]);
    }

    // -----------------
    //  Servicios
    // -----------------

    public function storeServicio(Request $request)
    {
        ServiciosLaboratorio::create($request->all());
        return back()->with(['info' => 'servicio agegado con exito', 'color' => 'success']);
    }

    public function deleteService($id)
    {
        ServiciosLaboratorio::find($id)->delete();
        return back()->with(['info' => 'servicio eliminado con exito', 'color' => 'danger']);
    }

    function deudaLaboratorio(Request $request)
    {

        $mes = $request->mes;
        $anio = $request->anio;
        $laboratorios = Laboratorio::all();

        // dd($mes, $anio);

        return view('reports.laboratorio.deuda', compact('laboratorios', 'mes', 'anio'));
    }
}
