<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GraficaController extends Controller
{

    // retorna las grfias estadica de los tratamientos mas usados para
    public function tratamientos(Request $request)
    {

        if ($request->mes) {

            $data = $this->getDataTomes($request->mes);
        } else {
            $data = $this->getDataTomes(date('m'));
        }


        // dd($data);
        $data2 = array();

        foreach ($data as $d) {
            array_push($data2, $d);
        }

        // dd($data2);
        return view('reports.graficas.mascomprado', ['masVendidos' => $data2, 'titulo' => 'tratamientos mas frecuentes']);
    }


    function getDataTomes($mes)
    {


        if ($mes  === '01') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',
                    'tr.tipo',
                    'tr.enero as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '02') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.febrero as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '03') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.marzo as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '04') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.abril as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '05') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.mayo as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '06') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.junio as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '07') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.julio as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '08') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.agosto as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '09') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.septiembre as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '10') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.octubre as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '11') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.noviembre as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
        if ($mes === '12') {
            return  DB::table('pago_docotores as pg')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select(
                    DB::raw('COUNT(pg.tratamiento_id) as tratamiento_id'),
                    'tr.nombre',
                    'tr.descripcion',

                    'tr.tipo',
                    'tr.diciembre as mes',
                )
                ->groupBy('pg.tratamiento_id')
                ->orderBy(DB::raw('pg.tratamiento_id'), 'asc')
                ->whereMonth('pg.created_at', $mes)
                ->whereYear('pg.created_at', date('Y'))
                // ->limit()
                ->get();
        }
    }

    // retorna las grfias estadica de los tratamientos mas usados para
    public function insumos()
    {
        $data =  DB::table('salida_insumos as sal')
            ->join('insumos as in', 'sal.insumo_id', '=', 'in.id')
            ->select(DB::raw('COUNT(sal.insumo_id) as tratamiento_id'), 'in.nombre')
            ->groupBy('sal.insumo_id')
            ->orderBy(DB::raw('sal.insumo_id'), 'asc')
            ->limit(20)
            ->get();

        // dd($data);
        $data2 = array();

        foreach ($data as $d) {
            array_push($data2, $d);
        }

        

        // dd($data2);
        return view('reports.graficas.insumos', ['masVendidos' => $data2, 'titulo' => 'insumos consumido frecuentemente']);
    }

    public function caja()
    {

        $diciembre = ($this->getTotalCuadresMes('12')->total) ? $this->getTotalCuadresMes('12')->total : 0;
        $noviembre = ($this->getTotalCuadresMes('11')->total) ? $this->getTotalCuadresMes('11')->total : 0;
        $octubre = ($this->getTotalCuadresMes('10')->total) ? $this->getTotalCuadresMes('10')->total : 0;
        $septiembre = ($this->getTotalCuadresMes('09')->total) ? $this->getTotalCuadresMes('09')->total : 0;
        $agosto = ($this->getTotalCuadresMes('08')->total) ? $this->getTotalCuadresMes('08')->total : 0;
        $julio = ($this->getTotalCuadresMes('07')->total) ? $this->getTotalCuadresMes('07')->total : 0;
        $junio = ($this->getTotalCuadresMes('06')->total) ? $this->getTotalCuadresMes('06')->total : 0;
        $mayo = ($this->getTotalCuadresMes('05')->total) ? $this->getTotalCuadresMes('05')->total : 0;
        $abril = ($this->getTotalCuadresMes('04')->total) ? $this->getTotalCuadresMes('04')->total : 0;
        $marzo = ($this->getTotalCuadresMes('03')->total) ? $this->getTotalCuadresMes('03')->total : 0;
        $febrero = ($this->getTotalCuadresMes('02')->total) ? $this->getTotalCuadresMes('02')->total : 0;
        $enero = ($this->getTotalCuadresMes('01')->total) ? $this->getTotalCuadresMes('01')->total : 0;



        return view('reports.graficas.caja', [
            'titulo' => 'insumos consumido frecuentemente',
            'enero' => $enero,
            'febrero' => $febrero,
            'marzo' => $marzo,
            'abril' => $abril,
            'mayo' => $mayo,
            'junio' => $junio,
            'julio' => $julio,
            'agosto' => $agosto,
            'septiembre' => $septiembre,
            'octubre' => $octubre,
            'noviembre' => $noviembre,
            'diciembre' => $diciembre
        ]);
    }

    public function getTotalCuadresMes($mes)
    {

        return  DB::table('cuadres')
            ->select('*', DB::raw('SUM(cuadre) as total'))
            ->whereMonth('created_at', $mes)
            ->whereYear('created_at', date('Y'))
            ->first();
    }
}
