<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FotoTratamiento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class FotoTratamientoController extends Controller
{


    public function index()
    {
        return view('admin.fotos.index', ['fotos' => FotoTratamiento::all()]);
    }

    public function create()
    {
        return view('admin.fotos.create');
    }

    public function store(Request $request)
    {
        $foto = new FotoTratamiento();

        $foto->titulo = $request->titulo;
        $foto->descripcion = $request->descripcion;

        if ($request->hasFile('foto')) {
            $file = $request->file('foto');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/galeria', $nombre);
            $foto->foto = $nombre; 
        }
        if ($request->hasFile('foto2')) {
            $file = $request->file('foto2');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/galeria', $nombre);
            $foto->foto2 = $nombre; 
        }
        if ($request->hasFile('foto3')) {
            $file = $request->file('foto3');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/galeria', $nombre);
            $foto->foto3 = $nombre; 
        }
        if ($request->hasFile('foto4')) {
            $file = $request->file('foto4');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/galeria', $nombre);
            $foto->foto4 = $nombre; 
        }
        if ($request->hasFile('foto5')) {
            $file = $request->file('foto5');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/galeria', $nombre);
            $foto->foto5 = $nombre; 
        }

        $foto->save();
        return back()->with(['info' => 'articulo para galeria publicado', 'color' => 'success']);
    }

    public function show($id)
    {
        return view('admin.fotos.show', ['data' => FotoTratamiento::find($id)]);
    }

    public function update(Request $request)
    {
        FotoTratamiento::find($request->id)->update($request->all());
        return back()->with(['info' => 'datos actualizados', 'color' => 'warning']);
    }

    public function delete($id)
    {
        $foto = FotoTratamiento::find($id);

        if ($foto->foto) {
            unlink(storage_path('app/public/galeria/'.$foto->foto));
        }
        if ($foto->foto2) {
            unlink(storage_path('app/public/galeria/'.$foto->foto2));
        }
        if ($foto->foto3) {
            unlink(storage_path('app/public/galeria/'.$foto->foto3));
        }
        if ($foto->foto4) {
            unlink(storage_path('app/public/galeria/'.$foto->foto4));
        }
        if ($foto->foto5) {
            unlink(storage_path('app/public/galeria/'.$foto->foto5));
        }
        
        $foto->delete();
        return back()->with(['info' => 'dato eliminados', 'color' => 'danger']);
    }

    


}
