<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FotoPaciente;
use Illuminate\Http\Request;

class FotoPacienteController extends Controller
{
    // lista las radiografias de los pacientes
    public function radiografias($id)
    {
        $radiografia = FotoPaciente::where('paciente_id', '=', $id)->get();


        return view('reports.pacientes.radiografias.rediografia', ['fotos' => $radiografia, 'paciente_id' => $id]);
    }

    // permite asiganar la foto
    public function store(Request $request)
    {

        // dd($request->all());
        $foto = new FotoPaciente();
        if ($request->foto) {
            // dd('entro');
            $file = $request->file('foto');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/pacientes', $nombre);
            $foto->foto = $nombre;
        }

        // dd($foto);
        $foto->paciente_id = $request->paciente_id;
        $foto->titulo = $request->titulo;
        $foto->save();
        return back()->with(['info' => 'foto asignada', 'color' => 'success']);
    }

    public function delete($id)
    {
        $foto = FotoPaciente::find($id);
        if ($foto->foto) {
            unlink(storage_path('app/public/pacientes/' . $foto->foto));
        }
        $foto->delete();
        return back()->with(['info' => 'foto eliminada con exito', 'color' => 'danger']);
    }
}
