<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EscanerDpi;
use Illuminate\Http\Request;

class EscanerController extends Controller
{


    public function index($id)
    {
        $escaner = EscanerDpi::where('paciente_id', $id)->first();
        return view('reports.pacientes.escaner_dpi', ['id' => $id, 'data' => $escaner]);
    }

    public function store(Request $request)
    {
        $foto = new EscanerDpi();
        if ($request->hasFile('lado1')) {
            $file = $request->file('lado1');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/pacientes/dpi', $nombre);
            $foto->foto1 = $nombre;
        }

        if ($request->hasFile('lado2')) {
            $file = $request->file('lado2');
            $nombre = date('ymdhis') . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/pacientes/dpi', $nombre);
            $foto->foto2 = $nombre;
        }
        $foto->paciente_id = $request->paciente_id;
        // dd($foto);
        $foto->save();
        return back()->with(['info' => 'dpi guardado', 'color' => 'success']);
    }
}
