<?php

namespace App\Http\Controllers\Admin;

use App\Models\Doctor;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DescuentoDoctor;
use App\Models\Ortodoncia;
use App\Models\PagoTratamiento;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class DoctoreController extends Controller
{

    public function index()
    {
        $doctores = Doctor::paginate();
        return view('admin.doctore.index', ['doctores' => $doctores]);
    }

    public function create()
    {
        abort_if(Gate::denies('doctor_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $doctore = new Doctor();
        return view('admin.doctore.create', compact('doctore'));
    }

    public function store(Request $request)
    {
        abort_if(Gate::denies('doctor_store'), Response::HTTP_FORBIDDEN, 'Forbidden');
        request()->validate(Doctor::$rules);

        $doctore = new Doctor($request->all());

        if ($request->hasFile('foto')) {
            $file = $request->file('foto');
            $nombre = time() . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/doctores', $nombre);
            $doctore->foto = $nombre;
        }
        if ($request->hasFile('titulo1')) {
            $file = $request->file('titulo1');
            $nombre = time() . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/doctores/titulos', $nombre);
            $doctore->titulo1 = $nombre;
        }
        if ($request->hasFile('titulo2')) {
            $file = $request->file('titulo2');
            $nombre = time() . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/doctores/titulos', $nombre);
            $doctore->titulo2 = $nombre;
        }
        if ($request->hasFile('titulo3')) {
            $file = $request->file('titulo3');
            $nombre = time() . $file->getClientOriginalName();
            $file->move(storage_path() . '/app/public/doctores/titulos', $nombre);
            $doctore->titulo3 = $nombre;
        }
        storeControl('registro un nuevo doctor');



        // dd('afuera');

        $doctore->save();
        return redirect()->route('doctores.index')
            ->with(['info' => 'Doctor Creado Con Exito', 'color' => 'success']);
    }

    public function show($id)
    {
        abort_if(Gate::denies('doctor_show'), Response::HTTP_FORBIDDEN, 'Forbidden');

        $doctore = Doctor::find($id);
        $historial = $this->getAllPagos($id);
        $total_Pago = $this->getPago($id);


        return view('admin.doctore.show', ['doctore' => $doctore, 'historial' => $historial, 'total_pago' => $total_Pago]);
    }

    public function edit($id)
    {
        abort_if(Gate::denies('doctor_update'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $doctore = Doctor::find($id);
        return view('admin.doctore.edit', compact('doctore'));
    }

    public function update(Request $request, Doctor $doctore)
    {
        abort_if(Gate::denies('doctor_update'), Response::HTTP_FORBIDDEN, 'Forbidden');
        $web = $request->input('web', 0);
        $doctore->web = $web;


        request()->validate(Doctor::$rules);

        storeControl('actualizo a un doctor');


        $doctore->update($request->all());
        return redirect()->route('doctores.index')
            ->with(['info' => 'Doctor Actualizado Con Exito', 'color' => 'warning']);
    }

    public function destroy($id)
    {
        abort_if(Gate::denies('doctor_delete'), Response::HTTP_FORBIDDEN, 'Forbidden');

        Doctor::find($id)->delete();
        storeControl('elimino a un doctor');

        return redirect()->route('doctores.index')
            ->with(['info' => 'Doctor Eliminado', 'color' => 'danger']);
    }


    // Retorna la vista para generar Reportes de los doctores
    public function reportes()
    {
        return view('admin.doctore.reportes');
    }


    // retorna el reporte de todos los docotores
    public function reporteAllDoctor(Request $request)
    {
        // TODO: AGREGAR SUMA DE PAGOS PARA CADA UNO POR MES ACTUAL Y COLOCAR FILTROS POR MES
        $doctores = Doctor::all();
        $mes = $request->mes;
        $anio = $request->anio;
        return view('reports.doctores.all', compact('doctores', 'mes', 'anio'));
    }

    // retorna el reporte de los doctoctore eliminados
    public function reportAllDelete()
    {
        return view('reports.doctores.all', ['doctores' => Doctor::where('deleted_at', '!=', null)->get(), 'estado' => 'eliminados']);
    }

    // retorna el historial de Procedimos relizados por un doctor
    public function getAllPagos($id)
    {
        return DB::table('pago_docotores as pd')
            ->join('tratamientos as tr', 'pd.tratamiento_id', '=', 'tr.id')
            ->join('pacientes as pac', 'pd.paciente_id', '=', 'pac.id')
            ->select(
                'pd.pieza',
                'pd.created_at',
                'tr.nombre as tratamiento',
                'tr.descripcion as descripcionTr',
                'tr.id as tratamiento_id',
                'tr.precio',
                'tr.tipo',
                'pac.nombre'
            )
            ->where('pd.doctor_id', $id)
            ->whereMonth('pd.created_at', date('m'))
            ->whereYear('pd.created_at', date('Y'))
            ->orderBy('pd.id', 'desc')
            ->get();
    }

    // retorna el total a pagar para un doctor para la vista show
    public function getPago($id)
    {
        $pagos = $this->getAllPagos($id);
        $total_pago = 0;
        for ($i = 0; $i < count($pagos); $i++) {

            // para buscar los procentajes de pago
            $pagoTatamiento = PagoTratamiento::where('doctor_id', $id)
                ->where('tratamiento_id', $pagos[$i]->tratamiento_id)
                ->first();

            $total_pago = $total_pago +  (($pagoTatamiento->porcentaje ?? 0)  * ($pagos[$i]->precio) / 100)  + ($pagoTatamiento->monto  ?? 0);
        }
        return $total_pago;
    }

    // retorna la vista para poder imprimir el historial y pago de doctores
    public function prindPagos($id, Request $request)
    {
        $doctore = Doctor::find($id);
        $historial = DB::table('pago_docotores as pd')
            ->join('tratamientos as tr', 'pd.tratamiento_id', '=', 'tr.id')
            ->join('pacientes as pac', 'pd.paciente_id', '=', 'pac.id')
            ->select(
                'pd.pieza',
                'pd.created_at',
                'tr.nombre as tratamiento',
                'tr.descripcion as descripcionTr',
                'tr.id as tratamiento_id',
                'tr.precio',
                'tr.tipo',
                'pac.nombre',
                'pac.id as paciente_id'
            )
            ->where('pd.doctor_id', $id)
            ->whereMonth('pd.created_at', $request->mes)
            ->whereYear('pd.created_at', $request->ano)
            ->orderBy('pd.id', 'desc')
            ->get();

        $total_pago = 0;

        for ($i = 0; $i < count($historial); $i++) {

            // para buscar los procentajes de pago
            $pagoTatamiento = PagoTratamiento::where('doctor_id', $id)
                ->where('tratamiento_id', $historial[$i]->tratamiento_id)
                ->first();


            $total_pago = $total_pago + (($pagoTatamiento->porcentaje ?? 0) * $historial[$i]->precio) / 100;
        }

        $descu = DB::table('descuento_doctors as des')
            ->select('des.*')
            ->where('des.doctor_id', $id)
            ->whereMonth('des.created_at', $request->mes)
            ->whereYear('des.created_at', $request->ano)
            ->get();



        return view('reports.doctores.pagos', ['doctore' => $doctore, 'historial' => $historial, 'total_Pago' => $total_pago, 'descuentos' => $descu]);
    }

    // retorna los pacientes que se registraron en ortodoncia
    public function paciente_orto($date)
    {
        return Ortodoncia::whereDate('created_at', $date)->get();
    }
}
