<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DiarioPaciente;
use App\Models\Paciente;
use Illuminate\Http\Request;

class DiarioController extends Controller
{
    public function index($id, Request $request)
    {

        $tipo = '';

        if ($request->query('tipo')) {
            $tipo = $request->query('tipo');
        }

        $diario = DiarioPaciente::where('paciente_id', $id)->orderBy('id', 'desc')->get();

        return view('reports.pacientes.diario', ['data' => $diario, 'paciente' => Paciente::findOrFail($id), 'tipo' => $tipo]);
    }

    public function store(Request $request)
    {
        DiarioPaciente::create($request->all());

        storeControl('registro en diario');

        return back()->with(['info' => 'datos de diario asignados', 'color' => 'success']);
    }


    public function destroy($id)
    {
        DiarioPaciente::findOrFail($id)->delete();
        storeControl('elimino de diario');

        return back()->with(['info' => 'diario elimano con exito ', 'color' => 'success']);
    }
}
