<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DescuentoDoctor;
use App\Models\Doctor;
use Illuminate\Http\Request;

class DescuentoDoctorController extends Controller
{
    public function index($id)
    {
        $data = DescuentoDoctor::where('doctor_id', $id)->get();
        $doc = Doctor::findOrFail($id);
        return view('reports.doctores.descuento', ['data' => $data, 'doc' => $doc]);
    }

    public function store(Request $request)
    {
        DescuentoDoctor::create($request->all());
        storeControl('registro descuento de doctor');

        return back()->with(['info' => 'descuento asigando con exito', 'color' => 'success']);
    }

    public function delete($id)
    {
        DescuentoDoctor::findOrFail($id)->delete();
        storeControl('elimino descuento de doctor');

        return back()->with(['info' => 'descuento elimida con exito', 'color' => 'success']);
    }
}
