<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Paciente;
use Carbon\Carbon;

class ConsentimientosController extends Controller
{

   public function consentimientos_infromados($id)
   {
      $paciente = Paciente::findOrFail($id);
      $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
      return view('reports.consentimientos.informados', ['paciente' => $paciente, 'edad' => $edad,]);
   }

   public function consentimientos_anestesia($id)
   {
      $paciente = Paciente::findOrFail($id);
      $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
      return view('reports.consentimientos.anestesia', ['paciente' => $paciente, 'edad' => $edad,]);
   }

   public function consentimientos_protesis($id)
   {
      $paciente = Paciente::findOrFail($id);
      $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
      return view('reports.consentimientos.protesisi', ['paciente' => $paciente, 'edad' => $edad,]);
   }

   public function consentimientos_endodoncia($id)
   {
      $paciente = Paciente::findOrFail($id);
      $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
      return view('reports.consentimientos.endodoncia', ['paciente' => $paciente, 'edad' => $edad,]);
   }

   public function consentimientos_extraccion($id)
   {
      $paciente = Paciente::findOrFail($id);
      $edad = Carbon::parse($paciente->fecha_nacimiento)->age;
      return view('reports.consentimientos.extraccion', ['paciente' => $paciente, 'edad' => $edad,]);
   }


}
