<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Articulo;
use App\Models\Compra;
use App\Models\CompraProveedores;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CompraController extends Controller
{
    // retorna la vista para comprar articulos
    public function index()
    {
        $articulos = DB::table('articulos as art')
            ->join('categoria as cat', 'art.categoria_id', '=', 'cat.id')
            ->select('cat.nombre as nomCat', 'cat.tipo', 'art.nombre', 'art.cod_barras', 'art.descripcion', 'art.p_venta', 'art.p_costo', 'art.stock', 'art.img', 'art.id')
            ->get();
        return view('admin.articulos.compras', ['articulos' => $articulos]);
    }

    public function store(Request $request)
    {
        $articulo = $this->guardar($request);

        storeControl('registro compra de articulo');

        // TODO: VER POR QUE SE PUEDA LLEVAR U REGISTRO DE COMPRAS MENSUALES Y DETERMINAR SI ES UN CREDITO 

        return back()->with(['info' => "Articulo $articulo->nombre $articulo->descripcion Comprado con exito", 'color' => 'success']);
    }
    // retorna la vista de historial
    public function shows(Request $request)
    {
        $show = false;
        $historias = null;
        if ($request->fin && $request->inicio) {
            $show = true;
            $historias = DB::table('compra_articulos as ca')
                ->join('articulos as art', 'ca.articulo_id', '=', 'art.id')
                ->join('users as use', 'ca.user_id', '=', 'use.id')
                ->select('art.nombre', 'art.descripcion', 'art.img', 'ca.id as idCom', 'ca.factura', 'ca.cantidad', 'ca.fecha', 'art.id', 'ca.user_id', 'use.name')
                ->whereBetween('ca.fecha', [$request->inicio, $request->fin])
                ->orderBy('ca.id', 'DESC')
                ->get();
        }


        return view('admin.articulos.historialCompras', ['articlos' => $historias, 'show' => $show]);
    }

    // guarda la compra de un articulo
    public function guardar(Request $request)
    {

        $fecha_actual = date("d-m-Y");
        $compra = new Compra();
        $compra->articulo_id = $request->articulo_id;
        $compra->cantidad = $request->cantidad;
        $compra->factura = $request->factura;
        $compra->fecha = $request->fecha;
        $compra->fecha_vencimiento =   date("Y-m-d", strtotime($fecha_actual . "+ 1 year"));
        $compra->user_id = Auth::user()->id;
        $articulo = Articulo::find($request->articulo_id);
        $articulo->stock = $articulo->stock + (float) $request->cantidad;
        $compra->save();
        $articulo->save();
        return $articulo;
    }

    public function delete($id, $idArt)
    {
        $compra = Compra::find($id);

        $articulo = Articulo::find($idArt);

        $articulo->stock = $articulo->stock - $compra->cantidad;

        $articulo->save();
        $compra->delete();


        storeControl('elimino compra de articulos');

        return back()->with(['info' => "Compra $articulo->nombre $articulo->descripcion Eliminda con exito", 'color' => 'danger']);
    }


    public function report()
    {

        $historias = DB::table('compra_articulos as ca')
            ->join('articulos as art', 'ca.articulo_id', '=', 'art.id')
            ->join('users as user', 'ca.user_id', '=', 'user.id')
            ->select(
                'art.nombre',
                'art.descripcion',
                'art.img',
                'ca.id as idCom',
                'ca.factura',
                'ca.cantidad',
                'ca.fecha',
                'art.id',
                'user.name as userName',
            )
            ->orderBy('ca.id', 'DESC')
            ->get();
        return view('reports.articulos.comprasHistorial', ['historial' => $historias]);
    }
}
