<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Color;
use Illuminate\Http\Request;

class ColoresController extends Controller
{

    public function index()
    {
        return view('admin.colorK.index', ['colors' => Color::all()]);
    }


    public function store(Request $request)
    {
        Color::create($request->all());

        return back()->with(['info' => 'COLOR Registrado Con Exito', 'color' => 'success']);
    }

    public function show($id)
    {
        $color = Color::find($id);
        return view('admin.colorK.show', ['color' => $color]);
    }

    public function update(Request $request, $id)
    {
        $color = Color::find($id)->update($request->all());
        return back()->with(['info' => 'COLOR ACTUALIZADO CON Exito', 'color' => 'warning']);
    }

    public function delete($id)
    {
        Color::find($id)->delete();

        return back()->with(['info' => 'comor eliminado con exito', 'color' => 'danger']);
    }
}
