<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Caja;
use App\Models\CajaSecundaria;
use App\Models\CajaSecuntaria;
use Illuminate\Http\Request;

class CajaSecuntariaController extends Controller
{
    /**
     * Muestra una lista de todas las instancias de CajaSecundaria.
     */
    public function index()
    {
        $entradas = CajaSecundaria::where('tipo', 'entrada')->get();
        $salidas = CajaSecundaria::where('tipo', 'salida')->get();

        $total_entrada = 0;
        $total_salida = 0;

        foreach ($entradas as $cajaSecundaria) {
            $total_entrada += $cajaSecundaria->valor;
        }

        foreach ($salidas as $cajaSecundaria) {
            $total_salida += $cajaSecundaria->valor;
        }

        return view('admin.caja_secundaria.index', compact('entradas', 'salidas', 'total_entrada', 'total_salida'));
    }

    /**
     * Muestra el formulario para crear una nueva instancia de CajaSecundaria.
     */
    public function create()
    {
        return view('admin.caja_secundaria.create');
    }

    /**
     * Almacena una nueva instancia de CajaSecundaria en la base de datos.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'valor' => 'required|numeric',
            'tipo' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
        ]);
        // dd($request->all());

        if (isset($request->check) && $request->tipo == 'SALIDA') {
            $caja = new Caja();
            $caja->valor = $request->valor;
            $caja->descripcion = $request->descripcion;
            $caja->operacion = 's';
            // $caja->factura = $data->factura;
            $caja->tipo = 'VARIABLE';
            $caja->fecha = date('Y-m-d');
            $caja->save();

            $cajac = new Caja();
            $cajac->valor = $request->valor;
            $cajac->descripcion = $request->descripcion;
            $cajac->operacion = 'e';
            $cajac->fecha = date('Y-m-d');
            $cajac->save();
        }
        // dd('Entro');
        CajaSecundaria::create($validatedData);
        return redirect()->route('caja-secundaria.index')->with(['info' => 'Caja Secundaria creada exitosamente.', 'color' => 'success']);
    }

    /**
     * Muestra una instancia específica de CajaSecundaria.
     */
    public function show(CajaSecundaria $cajaSecundaria)
    {
        return view('admin.caja_secundaria.show', compact('cajaSecundaria'));
    }

    /**
     * Muestra el formulario para editar una instancia de CajaSecundaria.
     */
    public function edit(CajaSecundaria $cajaSecundaria)
    {
        return view('admin.caja_secundaria.edit', compact('cajaSecundaria'));
    }

    /**
     * Actualiza una instancia específica de CajaSecundaria en la base de datos.
     */
    public function update(Request $request, CajaSecundaria $cajaSecundaria)
    {
        $validatedData = $request->validate([
            'valor' => 'required|numeric',
            'tipo' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
        ]);

        $cajaSecundaria->update($validatedData);

        return redirect()->route('caja-secundaria.index')->with('success', 'Caja Secundaria actualizada exitosamente.');
    }

    /**
     * Elimina una instancia específica de CajaSecundaria de la base de datos.
     */
    public function destroy(CajaSecundaria $cajaSecundaria)
    {
        $cajaSecundaria->delete();

        return redirect()->route('caja-secundaria.index')->with('success', 'Caja Secundaria eliminada exitosamente.');
    }
}
