<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Abono;
use App\Models\Caja;
use App\Models\Cuadre;
use App\Models\CuadreMedicamento;
use App\Models\CuadreOrto;
use App\Models\DeudaMeciamento;
use App\Models\Factura;
use App\Models\Ortodoncia;
use App\Models\PagoDoctor;
use App\Models\PagoTratamiento;
use App\Models\Salida;
use ArrayObject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CajaContrller extends Controller
{
    public function showEntrdas()
    {
        $entrada = $this->listentrada();
        $total = 0;

        foreach ($entrada as $ent) {
            $total =  $total + $ent->valor;
        }

        storeControl('registro en caja chica');

        return view('admin.caja.entradas', ['entradas' => $entrada, 'total' => $total]);
    }

    public function showSalidas()
    {
        $entrada = $this->listsalida();
        $total = 0;

        storeControl('registro en gatos');


        foreach ($entrada as $ent) {
            $total =  $total + $ent->valor;
        }

        return view('admin.caja.salidas', ['entradas' => $entrada, 'total' => $total]);
    }

    // guarda una entrada
    public function entrada(Request $data)
    {
        $caja = new Caja();
        $caja->valor = $data->valor;
        $caja->descripcion = $data->descripcion;
        $caja->operacion = 'e';
        $caja->fecha = date('Y-m-d');
        $caja->save();
        return back()->with(['info' => 'Entrada Registrada Con Exito', 'color' => 'success']);
    }

    // guarda una salida
    public function salida(Request $data)
    {

        $caja = new Caja();
        $caja->valor = $data->valor;
        $caja->descripcion = $data->descripcion;
        $caja->operacion = 's';
        $caja->factura = $data->factura;
        $caja->tipo = $data->tipo;
        $caja->fecha = date('Y-m-d');
        $caja->save();
        return back()->with(['info' => 'Salida de Efectivo Registrada Con Exito', 'color' => 'success']);
    }

    // devuelve un listado de las entradas
    public function listentrada()
    {
        $entrada = DB::table('cajas')
            ->where('operacion', 'e')
            ->whereDate('fecha', date('Y-m-d'))
            ->get();
        return $entrada;
    }

    // devuele un listado de las salidas
    public function listsalida()
    {
        $salida = DB::table('cajas')
            ->where('operacion', 's')
            ->whereDate('fecha', date('Y-m-d'))
            ->get();
        return $salida;
    }


    // muestra la vista para cuader de caja
    public function cuadre()
    {
        $salida = $this->listsalida();

        $totalSalida = 0;
        foreach ($salida as $sal) {
            $totalSalida = $sal->valor + $totalSalida;
        }

        $entrada = $this->listentrada();
        $totalEntrada = 0;
        foreach ($entrada as $ent) {
            $totalEntrada = $totalEntrada + $ent->valor;
        }
        $abonos = $this->abonos(date('Y-m-d'));

        return view('admin.caja.cuadre', [
            'entradas' => $totalEntrada,
            'salida' => $totalSalida,
            'abonos' => $abonos
        ]);
    }

    // guarda un cuadre de caja
    public function cuadreStore(Request $data)
    {
        $cuadre = new Cuadre();
        $cuadre->entrada = $data->entrada;
        $cuadre->salida = $data->salida;
        $cuadre->cuadre = $data->cuadre;
        $cuadre->totalEfectico = $data->efectivo;
        $cuadre->faltante = $data->faltante;
        $cuadre->totalVisas = $data->visas;
        $cuadre->deuda_medicamento = $data->deuda_medicamento;
        $cuadre->save();

        storeControl('registro cuadre del dia');


        return back()->with(['info' => 'Cuadre Del Dia Registrado', 'color' => 'success', 'cuadre_id' => $cuadre->id]);
    }

    // reporte para el cuadre de la caja
    public function cuadrereport()
    {

        $cuadres = Cuadre::orderBy('created_at', 'ASC')->whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->get();
        $cuadreMedicamento = CuadreMedicamento::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->get();
        $cuadreOrto = CuadreOrto::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->get();

        return view('reports.caja.cuadre', ['cuadres' => $cuadres, 'cuadreMedicamento' => $cuadreMedicamento, 'cuadreOrto' =>  $cuadreOrto]);
    }

    public function deleteCuadre($id)
    {
        $caudre = Cuadre::find($id);
        $caudre->delete();

        storeControl('Elimino Un un cuadre');

        return back()->with(['info' => "Cuadre del Dia $caudre->fecha eliminado con Exito", 'color' => 'danger']);
    }

    public function salidaDelete($id)
    {
        $caja = Caja::find($id);
        $caja->delete();
        storeControl('elimino en gastos');

        return back()->with(['info' => "Salida Eliminada Con exito", 'color' => 'danger']);
    }

    public function entradaDelete($id)
    {
        $caja = Caja::find($id);
        $caja->delete();
        storeControl('elimino en caja chica');

        return back()->with(['info' => "Entrada Eliminada Con exito", 'color' => 'danger']);
    }

    // retorna la lista para ver hitorial de movimientos
    public function movimientos()
    {
        return view('admin.caja.movimientos');
    }

    // retorna el Reporte de Salidas Filtrado por fecha
    public function salidaReport(Request $request)
    {

        $data = $this->operacionFilter($request, 's');
        $total = 0;
        foreach ($data as $ta) {
            $total = $total + $ta->valor;
        }
        return view('reports.caja.salidas', ['data' => $data, 'total' => $total]);
    }

    // retorna reporte de Entradas Filtradas por fecha
    public function entradasReport(Request $request)
    {
        $data = $this->operacionFilter($request, 'e');
        $total = 0;
        foreach ($data as $ta) {
            $total = $total + $ta->valor;
        }
        return view('reports.caja.entradas', ['data' => $data, 'total' => $total]);
    }


    // funcios para retornar el listado de operacion deseadas
    public function operacionFilter(Request $request, $operacion)
    {
        $data = Caja::where('operacion', $operacion)
            ->whereBetween('fecha', [$request->desde, $request->hasta])->get();
        return $data;
    }

    // retorna el total de cuadre por fecha
    public function cuadreFecha($fecha)
    {
        $salida =  DB::table('cajas')
            ->where('operacion', 's')
            ->whereDate('fecha', $fecha)
            ->get();
        $entrada = DB::table('cajas')
            ->where('operacion', 'e')
            ->whereDate('fecha', $fecha)
            ->get();

        $ventas = DB::table('venta_articulos AS ven')
            ->join('articulos AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )->whereDate('ven.created_at', $fecha)
            ->get();

        $abonos = $this->abonos($fecha);
        $laboratorios = $this->laboratorios($fecha);
        $deudaMedicamento = $this->deudaMedicamento($fecha);

        $h_abonos = Abono::where('created_at', 'like', '%' . $fecha . '%')->get();

        $pagos = PagoDoctor::where('created_at', 'like', '%' . $fecha . '%')->get();

        $tpg = 0;
        foreach ($pagos as $p) {
            $p2 =
                DB::table('pago_tratamientos as pg')
                ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
                ->where('doctor_id', $p->doctor_id)
                ->where('tratamiento_id', $p->tratamiento_id)
                ->first();
            $aux = ($p2->precio ?? 0) * ($p2->porcentaje ?? 0) / 100;
            $tpg += $aux;
        }

        $orto = $this->orto_Date($fecha);

        $salidaOrto = Salida::whereDate('created_at', date('Y-m-d'))->get();

        $t_salida_orto = 0;

        foreach ($salidaOrto as $s) {
            $t_salida_orto += $s->valor;
        }

        return view('reports.caja.fecha', [
            'salidas' => $salida,
            'entradas' => $entrada,
            'ventas' => $ventas,
            'abonos' => $abonos,
            'laboratorios' => $laboratorios,
            'deudaMedicamento' => $deudaMedicamento,
            'h_abonos' => $h_abonos,
            'pagos' => $pagos,
            'fecha' => $fecha,
            'total_pago_doctors' => $tpg,
            'orto' => $orto,
            'salidas_orto' => $salidaOrto
        ]);
    }

    // retorna la vista para cuadre filtrado por mes y año
    public function cuadrereportFilter(Request $request)
    {

        $cuadres = Cuadre::whereMonth('created_at', $request->mes)
            ->whereYear('created_at', $request->ano)
            ->orderBy('created_at', 'desc')
            ->get();

        $cuadreMedicamento = CuadreMedicamento::whereYear('created_at', $request->ano)->whereMonth('created_at', $request->mes)->get();
        $cuadreOrto = CuadreOrto::whereYear('created_at', $request->ano)->whereMonth('created_at', $request->mes)->get();

        return view('reports.caja.cuadre', ['cuadres' => $cuadres, 'cuadreMedicamento' => $cuadreMedicamento, 'cuadreOrto' => $cuadreOrto]);
    }


    // retorna los abonos del dia
    public function abonos($fecha)
    {

        $totales = array();

        $efectivos = Abono::where('created_at', 'like', '%' . $fecha . '%')
            ->where('tipo', 'EFECTIVO')
            ->get();
        $efectivo = 0;
        foreach ($efectivos as $dato) {
            $efectivo += $dato->valor;
        }

        $visas =  Abono::where('created_at', 'like', '%' . $fecha . '%')
            ->where('tipo', 'VISA')
            ->get();
        $visa = 0;
        foreach ($visas as $dato) {
            $visa += $dato->valor + $dato->incremento;
        }

        $transeferencias = Abono::where('created_at', 'like', '%' . $fecha . '%')
            ->where('tipo', 'TRANSFERENCIA')
            ->get();
        $transeferencia = 0;
        foreach ($transeferencias as $dato) {
            $transeferencia += $dato->valor;
        }


        $depositos = Abono::where('created_at', 'like', '%' . $fecha . '%')
            ->where('tipo', 'DEPOSITO')
            ->get();
        $deposito = 0;
        foreach ($depositos as $dato) {
            $deposito += $dato->valor;
        }

        $otros = Abono::where('created_at', 'like', '%' . $fecha . '%')
            ->where('tipo', 'OTRO')
            ->get();
        $otro = 0;
        foreach ($otros as $dato) {
            $otro += $dato->valor;
        }

        array_push($totales, $efectivo, $visa, $transeferencia, $deposito, $otro);

        return $totales;
    }


    public function abonosDate($inicio = null, $fin = null)
    {

        $totales = array();

        $efectivos = Abono::whereBetween('created_at', [$inicio, $fin])
            ->where('tipo', 'EFECTIVO')
            ->get();
        $efectivo = 0;
        foreach ($efectivos as $dato) {
            $efectivo += $dato->valor;
        }

        $visas =  Abono::whereBetween('created_at', [$inicio, $fin])
            ->where('tipo', 'VISA')
            ->get();
        $visa = 0;
        foreach ($visas as $dato) {
            $visa += $dato->valor + $dato->incremento;
        }

        $transeferencias = Abono::whereBetween('created_at', [$inicio, $fin])
            ->where('tipo', 'TRANSFERENCIA')
            ->get();
        $transeferencia = 0;
        foreach ($transeferencias as $dato) {
            $transeferencia += $dato->valor;
        }


        $depositos = Abono::whereBetween('created_at', [$inicio, $fin])
            ->where('tipo', 'DEPOSITO')
            ->get();
        $deposito = 0;
        foreach ($depositos as $dato) {
            $deposito += $dato->valor;
        }

        $otros = Abono::whereBetween('created_at', [$inicio, $fin])
            ->where('tipo', 'OTRO')
            ->get();
        $otro = 0;
        foreach ($otros as $dato) {
            $otro += $dato->valor;
        }

        array_push($totales, $efectivo, $visa, $transeferencia, $deposito, $otro);

        return $totales;
    }

    // retorna los registro de pacientes para laboratorios
    public function laboratorios($fecha)
    {
        return DB::table('paciente_l_aboratorios as  pl')
            ->join('pacientes as pac', 'pl.paciente_id', '=', 'pac.id')
            ->join('laboratorios as lab', 'pl.laboratorio_id', '=', 'lab.id')
            ->select('pl.total', 'pl.descripcion', 'pl.created_at', 'lab.nombre', 'pl.id', 'pac.nombre as paciente')
            ->whereDate('pl.created_at', $fecha)
            ->get();
    }


    // deudas de medicamento_
    public function deudaMedicamento($fecha)
    {
        $deudas = DeudaMeciamento::whereDate('created_at', $fecha)->get();
        $total = 0;
        foreach ($deudas as $deu) {
            $total += $deu->total;
        }
        return $total;
    }


    public function deudaMedicamentoDate($inicio, $fin)
    {
        $deudas = DeudaMeciamento::wherebetween('created_at', [$inicio, $fin])->get();
        $total = 0;
        foreach ($deudas as $deu) {
            $total += $deu->total;
        }
        return $total;
    }




    // retorna la vista para poder imprimir el cuadre en la impresora Termica
    public function printCuadre($id)
    {
        $cuadre = Cuadre::find($id);
        return view('reports.caja.cuadreprint', ['data' => $cuadre]);
    }

    // retorna los movimientos filtrados por dia en especifico
    public function movimientos_dia(Request $request)
    {
        $salida =  DB::table('cajas')
            ->where('operacion', 's')
            ->whereDate('fecha', $request->fecha)
            ->get();
        $entrada = DB::table('cajas')
            ->where('operacion', 'e')
            ->whereDate('fecha', $request->fecha)
            ->get();

        $pagos_doc = DB::table('cajas')
            ->where('operacion', 'p')
            ->whereDate('fecha', $request->fecha)
            ->get();

        $ventas = DB::table('venta_articulos AS ven')
            ->join('articulos AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )->whereDate('ven.created_at', $request->fecha)
            ->get();

        $abonos = $this->abonos($request->fecha);
        $laboratorios = $this->laboratorios($request->fecha);
        $deudaMedicamento = $this->deudaMedicamento($request->fecha);
        $h_abonos = Abono::where('created_at', 'like', '%' . $request->fecha . '%')->get();
        $pagos = PagoDoctor::where('created_at', 'like', '%' . $request->fecha . '%')->get();
        $auxx = new ArrayObject();

        $tpg = 0;
        foreach ($pagos as $p) {

            $p2 =
                DB::table('pago_tratamientos as pg')
                ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
                ->where('doctor_id', $p->doctor_id)
                ->where('tratamiento_id', $p->tratamiento_id)
                ->first();
            // $aux = ($p2->precio * $p2->porcentaje) / 100;
            // $tpg += $aux;

            $auxx->append($p2);
        }

        $orto = $this->orto_Date($request->fecha);

        $salidaOrto = Salida::whereDate('created_at', date('Y-m-d'))->get();

        $t_salida_orto = 0;

        foreach ($salidaOrto as $s) {
            $t_salida_orto += $s->valor;
        }


        return view('reports.caja.fecha', [
            'salidas' => $salida,
            'entradas' => $entrada,
            'ventas' => $ventas,
            'abonos' => $abonos,
            'laboratorios' => $laboratorios,
            'deudaMedicamento' => $deudaMedicamento,
            'h_abonos' => $h_abonos,
            'pagos' => $pagos,
            'fecha' => $request->fecha,
            'total_pago_doctors' => $tpg,
            'orto' => $orto,
            't_salida_orto' => $t_salida_orto,
            'salidas_orto' => $salidaOrto
        ]);
    }


    function moviemintentoToDates(Request $request)
    {


        $salida =  DB::table('cajas')
            ->where('operacion', 's')
            ->whereBetween('fecha', [$request->inicio, $request->fin])
            ->get();
        $entrada = DB::table('cajas')
            ->where('operacion', 'e')
            ->whereBetween('fecha', [$request->inicio, $request->fin])

            ->get();

        $pagos_doc = DB::table('cajas')
            ->where('operacion', 'p')
            ->whereBetween('fecha', [$request->inicio, $request->fin])

            ->get();

        $ventas = DB::table('venta_articulos AS ven')
            ->join('articulos AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.total',
                'ven.descuento',
                'ven.credito',
                'ven.created_at as fechaVenta',
                'ven.cliente',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'fac.total as facTotal',
                'fac.descuento  as facDec',
                'fac.id  as facid',
                'fac.descripcion as facDes'
            )
            ->whereBetween('ven.created_at', [$request->inicio, $request->fin])

            ->get();

        $abonos = $this->abonosDate($request->inicio, $request->fin);
        $laboratorios =  DB::table('paciente_l_aboratorios as  pl')
            ->join('pacientes as pac', 'pl.paciente_id', '=', 'pac.id')
            ->join('laboratorios as lab', 'pl.laboratorio_id', '=', 'lab.id')
            ->select('pl.total', 'pl.descripcion', 'pl.created_at', 'lab.nombre', 'pl.id', 'pac.nombre as paciente')
            ->whereBetween('pl.created_at', [$request->inicio, $request->fin])
            ->get();
        $deudaMedicamento = $this->deudaMedicamentoDate($request->inicio, $request->fin);
        $h_abonos = Abono::whereBetween('created_at', [$request->inicio, $request->fin])->get();
        $pagos = PagoDoctor::whereBetween('created_at', [$request->inicio, $request->fin])->get();
        $auxx = new ArrayObject();

        $tpg = 0;
        foreach ($pagos as $p) {

            $p2 =
                DB::table('pago_tratamientos as pg')
                ->join('doctores as doc', 'pg.doctor_id', '=', 'doc.id')
                ->join('tratamientos as tr', 'pg.tratamiento_id', '=', 'tr.id')
                ->select('doc.nombre as doctor', 'doc.especialidad', 'tr.nombre as tratamiento', 'tr.precio', 'tr.tipo', 'pg.porcentaje', 'pg.id', 'tr.precio')
                ->where('doctor_id', $p->doctor_id)
                ->where('tratamiento_id', $p->tratamiento_id)
                ->first();
            // $aux = ($p2->precio * $p2->porcentaje) / 100;
            // $tpg += $aux;

            $auxx->append($p2);
        }

        $orto = $this->orto_Date($request->fecha);

        $salidaOrto = Salida::whereDate('created_at', date('Y-m-d'))->get();

        $t_salida_orto = 0;

        foreach ($salidaOrto as $s) {
            $t_salida_orto += $s->valor;
        }


        return view('reports.caja.entrefecha', [
            'abonos' => $abonos,
            'deudaMedicamento' => $deudaMedicamento,
            'entradas' => $entrada,
            'fecha' => $request->fecha,
            'h_abonos' => $h_abonos,
            'laboratorios' => $laboratorios,
            'orto' => $orto,
            'pagos' => $pagos,
            'salidas_orto' => $salidaOrto,
            'salidas' => $salida,
            't_salida_orto' => $t_salida_orto,
            'total_pago_doctors' => $tpg,
            'ventas' => $ventas,
        ]);
    }

    // ----------------------------------------------------------------
    // ---------------- PARA CUADRE DE  MEDICAMENTO -------------------
    // ----------------------------------------------------------------

    // retorna la vista para poder realizar un cuadre de ventas de medicamentos
    public function cuadre_medicamentos()
    {

        $ventasDiaMino =
            DB::table('venta_articulos')
            ->whereDate('created_at', date('Y-m-d'))
            ->where('credito', 0)
            ->where('mayorista', 0)
            ->get();

        $ventasDiaMayo =
            DB::table('facturas')
            ->where('mayoristas', 1)
            ->whereDate('created_at', date('Y-m-d'))
            ->get();

        $totalVentas = 0;
        foreach ($ventasDiaMino as $ven) {
            $totalVentas = $totalVentas + $ven->total;
        }
        $totalVentaMayo = 0;
        foreach ($ventasDiaMayo as $ven) {
            $totalVentaMayo = $totalVentaMayo + $ven->total;
        }
        $deudamedicamentos = $this->deudaMedicamento(date('Y-m-d'));

        $efectivo = Factura::whereDate('created_at', date('Y-m-d'))->where('descripcion_min', 'Efectivo')->sum('total');
        $tarjeta = Factura::whereDate('created_at', date('Y-m-d'))->where('descripcion_min', 'Tarjeta')->sum('total');
        $transferencia = Factura::whereDate('created_at', date('Y-m-d'))->where('descripcion_min', 'Transferencia')->sum('total');
        $deposito = Factura::whereDate('created_at', date('Y-m-d'))->where('descripcion_min', 'Deposito')->sum('total');
        $otro = Factura::whereDate('created_at', date('Y-m-d'))->where('descripcion_min', 'Otro')->sum('total');


        return view('admin.caja.caudreMed', [
            'ventas' => $totalVentas,
            'ventasMayo' => $totalVentaMayo,
            'deudaMedicamento' => $deudamedicamentos,
            'efectivo' => $efectivo,
            'tarjeta' => $tarjeta,
            'transferencia' => $transferencia,
            'deposito' => $deposito,
            'otro' => $otro
        ]);
    }

    public function cuadre_med_store(Request $request)
    {
        $cuadre = new CuadreMedicamento();
        $cuadre->cuadre = $request->cuadre;
        $cuadre->totalEfectico = $request->efectivo;
        $cuadre->faltante = $request->faltante;
        $cuadre->totalVisas = $request->visas;
        $cuadre->deuda_medicamento = $request->deuda_medicamento;
        $cuadre->save();
        return back()->with(['info' => 'Cuadre De Medicamento Registrado', 'color' => 'success', 'cuadre_med_id' => $cuadre->id]);
    }


    public function printCuadreMedi($id)
    {
        $cuadre = CuadreMedicamento::find($id);

        return view('reports.caja.cuadreMes', compact('cuadre'));
    }


    // retorna los datos  de ortodoncia para cuadre
    public function orto_Date($date)
    {
        return Ortodoncia::whereDate('created_at', $date)->get();
    }


    // retona el cuade de ortodoncia
    public function cuadreOrto()
    {
        $orto = $this->orto_Date(date('Y-m-d'));
        $t_orto = 0;

        $salidaOrto = Salida::whereDate('created_at', date('Y-m-d'))->get();

        $t_salida_orto = 0;

        foreach ($salidaOrto as $s) {
            $t_salida_orto += $s->valor;
        }

        foreach ($orto as $o) {
            $t_orto += $o->total;
        }
        return view('admin.caja.cuadreOrtodoncia', compact('t_orto', 't_salida_orto'));
    }


    public function cuadre_ortodoncia_store(Request $request)
    {
        // dd('entro');
        $cuadre = new CuadreOrto();
        $cuadre->cuadre = $request->cuadre;
        $cuadre->totalEfectico = $request->efectivo;
        $cuadre->faltante = $request->faltante;
        $cuadre->totalVisas = $request->visas;
        $cuadre->save();
        return back()->with(['info' => 'Cuadre De Ortodoncia Registrado', 'color' => 'success', 'cuadre_orto_id' => $cuadre->id]);
    }


    public function printCuadreOrto($id)
    {
        $cuadre = CuadreOrto::find($id);

        return view('reports.caja.cuadreOrto', compact('cuadre'));
    }
}
