<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BodegaKanaus;
use Illuminate\Http\Request;

class BodegaKanausController extends Controller
{
    public function index()
    {
        return view('admin.bodegas.index', ['bodegas' => BodegaKanaus::all()]);
    }

    public function show($id)
    {
        return view('admin.bodegas.show', ['bodega' => BodegaKanaus::find($id)]);
    }

    public function update(Request $data, $id)
    {
        BodegaKanaus::find($id)->update($data->all());
        return back()->with(['info' => "Categoria Actualizada Con exito", 'color' => 'info']);
    }

    public function store(Request $data)
    {
        BodegaKanaus::create($data->all());

        return back()->with(['info' => "categoria Guardada Con exito", 'color' => 'success']);
    }

    public function create()
    {
        return view('admin.bodegas.create');
    }

    public function delete($id)
    {
      BodegaKanaus::find($id)->delete();
  

        return back()->with(['info' => "categoria Eliminda Con exito", 'color' => 'danger']);
    }

    public function reporte()
    {
        return view('reports.bodega.report', ['bodegas' => BodegaKanaus::all()]);
    }
}
