<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ArticuloKanaus;
use App\Models\BodegaKanaus;
use App\Models\Color;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ArticuloKanausController extends Controller
{
    public function index()
    {
        $articulos = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo')
            ->where('art.deleted_at', null)
            ->get();
        return view('admin.articuloK.index', ['articulos' => $articulos]);
    }

    public function create()
    {
        return view('admin.articuloK.create', ['color' => Color::all(), 'bodegas' => BodegaKanaus::all()]);
    }

    public function store(Request $request)
    {
        $articulo = new ArticuloKanaus();
        $articulo->color_id = $request->color_id;
        $articulo->bodega_id = $request->bodega_id;
        $articulo->talla = $request->talla;

        $code = '';
        if (!$request->cod_barras) {
            $code = date("mYdihs");
            $articulo->codigo = $code;
        } else {
            $articulo->codigo = $request->codigo;
        }
        $articulo->p_venta = $request->p_venta;
        $articulo->p_costo = $request->p_costo;
        $articulo->stock = $request->stock;
        $articulo->min_stock = $request->min_stock;

        $articulo->save();

        return back()->with(['info' => "Articulo registrado con exito", 'color' => 'success']);
    }

    public function show($id)
    {
        $articulo = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo', 'art.bodega_id', 'art.color_id', 'art.id', 'art.p_costo')
            ->where('art.id', $id)
            ->first();



        return view('admin.articuloK.show', ['articulo' => $articulo, 'color' => Color::all(), 'bodegas' => BodegaKanaus::all()]);
    }

    public function update(Request $request, $id)
    {
        $this->actualizar($request, $id);
        return back()->with(['info' => "Articulo actualizado con exito", 'color' => 'warning']);
    }

    public function destroy($id)
    {
        $articulo = ArticuloKanaus::find($id);
        $articulo->delete();
        return back()->with(['info' => "Articulo $articulo->nombre  $articulo->descripcion Eliminado con exito", 'color' => 'danger']);
    }

    // retorna la vista pra el control de stock
    public function controlStock()
    {
        $articulos = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo', 'art.bodega_id', 'art.color_id', 'art.id',)
            ->where('art.deleted_at', null)
            ->get();
        return view('admin.articulos.contro_stock', ['articulos' => $articulos]);
    }

    public function actualizar(Request $request, $id)
    {
        return  ArticuloKanaus::find($id)->update($request->all());
    }

    // devuelve la vista para poder generar reportes para los articulos
    public function reportes()
    {
        return view('admin.articulos.reportes');
    }

    // devuelve un listado de todos los articulos
    public function reportAll()
    {
        $articulos = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo')
            ->where('art.deleted_at', null)
            ->get();
        $total = 0;

        foreach ($articulos as $art) {
            $total++;
        }

        return view('reports.articulos.all', ['articulos' => $articulos, 'total' => $total]);
    }

    // devuelve un listado de todos los articulos con stock < 5
    public function reportAllmin()
    {
        $articulos = DB::table('articulo_kanauses as art')
            ->join('colors as col', 'art.color_id', '=', 'col.id')
            ->join('bodega_kanauses as bod', 'art.bodega_id', '=', 'bod.id')
            ->select('art.talla', 'art.id', 'art.p_venta', 'art.codigo', 'bod.nombre as bodega', 'col.nombre as color', 'art.stock', 'art.min_stock', 'art.codigo')
            ->where('art.deleted_at', null)
            ->get();
        $total = 0;

        foreach ($articulos as $art) {
            $total++;
        }

        return view('reports.articulos.allmin', ['articulos' => $articulos, 'total' => $total]);
    }




    public function dataPrint($id)
    {
        $articulo = ArticuloKanaus::find($id);
        return view('reports.articulos.print-data', ['articulo' => $articulo]);
    }
}
