<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Articulo;
use App\Models\Categoria;
use App\Models\LoteStock;
use App\Models\Proveedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ArticuloController extends Controller
{

    public function index()
    {
        return view('admin.articulos.index', ['articulos' => Articulo::orderBy('id', 'ASC')->get(), 'categoria' => Categoria::all()]);
    }

    public function create()
    {
        return view('admin.articulos.create', ['categoria' => Categoria::all(), 'proveedor' => Proveedor::all()]);
    }

    public function store(Request $request)
    {

        // dd($request->all());

        $articulo = new Articulo();
        $articulo->nombre = $request->nombre;
        $articulo->categoria_id = $request->categoria_id;
        $articulo->proveedor_id = $request->proveedor_id;
        $code = '';
        if (!$request->cod_barras) {
            $code = date("mYdihs");
            $articulo->cod_barras = $code;
        } else {

            $articulo->cod_barras = $request->cod_barras;
        }
        $articulo->descripcion = $request->descripcion;
        $articulo->descripcion_interna = $request->descripcion_interna;
        $articulo->p_venta = $request->p_venta;
        $articulo->p_costo = $request->p_costo;
        $articulo->stock = $request->stock ?? 1;
        $articulo->img = $request->img;
        $articulo->fecha_promo = $request->fecha_promo;

        $articulo->min_stock = $request->min_stock;



        $articulo->save();

        // dd($articulo->id);


        foreach ($request->lotes as $lote) {
            LoteStock::create([
                'articulo_id' => $articulo->id,
                'cantidad' => $lote['cantidad'],
                'fecha_caducidad' => $lote['fecha_caducidad'],
            ]);
        }

        storeControl('Registro Un Articulo');

        return back()->with(['info' => "Articulo $articulo->nombre  $articulo->descripcion registrado con exito", 'color' => 'success']);
    }

    public function show($id)
    {
        $articulo = DB::table('articulos as art')
            ->join('categoria as cat', 'art.categoria_id', '=', 'cat.id')
            ->join('proveedores as prove', 'art.proveedor_id', '=', 'prove.id')
            ->select(
                'cat.nombre as nomCat',
                'cat.tipo',
                'art.nombre',
                'art.cod_barras',
                'art.descripcion',
                'art.p_venta',
                'art.p_costo',
                'art.stock',
                'art.img',
                'art.id',
                'art.fecha_promo',
                'art.created_at',
                'art.descripcion_interna',
                'art.min_stock',
                'art.categoria_id',
                'prove.nombre as provName',
                'prove.telefono1',
                'prove.telefono2',
                'prove.id as proveId',
                'prove.articulos'
            )
            ->where('art.id', $id)
            ->first();

        $articulo = Articulo::find($id);

        return view('admin.articulos.show', ['articulo' => $articulo, 'categoria' => Categoria::all(), 'proveedor' => Proveedor::all(), 'data' => $articulo]);
    }

    function updateDB()
    {
        $data = Articulo::all();

        return view('admin.articulos.artdb', compact('data'));
    }

    public function update(Request $request, $id)
    {
        $this->actualizar($request, $id);
        storeControl('actualizo Un Articulo');
        return back()->with(['info' => "Articulo actualizado con exito", 'color' => 'warning']);
    }

    public function destroy($id)
    {
        $articulo = Articulo::find($id);
        $articulo->delete();

        storeControl('Elimino Un Articulo');
        return back()->with(['info' => "Articulo $articulo->nombre  $articulo->descripcion Eliminado con exito", 'color' => 'danger']);
    }

    // retorna la vista pra el control de stock
    public function controlStock()
    {
        $articulo = Articulo::all();
        return view('admin.articulos.contro_stock', ['articulos' => $articulo]);
    }

    public function actualizar(Request $request, $id)
    {

        $articulo =  Articulo::find($id);
        $articulo->update($request->except('lotes'));


        // dd($articulo->lotes());

        // Eliminar lotes existentes
        $articulo->lotes()->delete();

        // Crear nuevos lotes
        foreach ($request->lotes as $lote) {
            LoteStock::create([
                'articulo_id' => $articulo->id,
                'cantidad' => $lote['cantidad'],
                'fecha_caducidad' => $lote['fecha_caducidad'],
            ]);
        }

        return $articulo;
    }

    // devuelve la vista para poder generar reportes para los articulos
    public function reportes()
    {
        return view('admin.articulos.reportes');
    }

    // devuelve un listado de todos los articulos
    public function reportAll()
    {
        $articulos = DB::table('articulos as art')
            ->join('categoria as cat', 'art.categoria_id', '=', 'cat.id')
            ->select('cat.nombre as nomCat', 'cat.tipo', 'art.nombre', 'art.cod_barras', 'art.descripcion', 'art.p_venta', 'art.p_costo', 'art.stock', 'art.img', 'art.id')
            ->get();
        $total = 0;

        foreach ($articulos as $art) {
            $total++;
        }

        return view('reports.articulos.all', ['articulos' => $articulos, 'total' => $total]);
    }

    // devuelve un listado de todos los articulos con stock < 5
    public function reportAllmin()
    {
        $articulos = Articulo::all();
        $total = 0;


        return view('reports.articulos.allmin', ['articulos' => $articulos, 'total' => $total]);
    }

    public function stockControl()
    {
        return view('reports.articulos.stock', ['articulos' => Articulo::all(), 'total' => Articulo::count()]);
    }

    public function articulosvendidos(Request $data)
    {
        $vendidios = DB::table('venta_articulos AS ven')
            ->join('articulos AS art', 'ven.articulo_id', '=', 'art.id')
            ->join('facturas AS fac', 'ven.factura_id', '=', 'fac.id')
            ->select(
                'ven.id',
                'ven.factura_id',
                'ven.articulo_id',
                'ven.cantidad',
                'ven.created_at as fechaVenta',
                'art.nombre as nomArt',
                'art.cod_barras',
                'art.descripcion'

            )
            ->whereMonth('ven.created_at', $data->mes)
            ->whereYear('ven.created_at', $data->ano)
            ->get();


        return view('reports.articulos.vendidos', ['articulos' => $vendidios]);
    }

    public function dataPrint($id)
    {
        $articulo = Articulo::find($id);
        return view('reports.articulos.print-data', ['articulo' => $articulo]);
    }
}
