<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Abono;
use App\Models\ControlUser;
use App\Models\DeudaPaciente;
use App\Models\Paciente;
use App\Models\Tratamiento;
use Illuminate\Http\Request;

class AbonosController extends Controller
{

    public function abonar($paciente, $id)
    {
        $abonos = $this->abonos($id);

        // dd($abonos);

        $deudaPaciente = DeudaPaciente::where('paciente_id', $id)->get();
        return view('reports.pacientes.abonos', ['id' => $id, 'paciente' => $paciente, 'abonos' => $abonos, 'deudaPaciente' => $deudaPaciente]);
    }

    public function store(Request $request)
    {

        // dd($request->all());

        $tr = Tratamiento::where('id', $request->tratamiento_id)->first();

        // dd($tr);
        $ab = new Abono();
        $ab->valor = $request->valor;
        $ab->descripcion = 'Abono a: ' . $tr?->nombre  . ' ' . $tr?->descripcion . ' - ' . $request->descripcion;
        $ab->factura = $request->factura;
        $ab->tipo = $request->tipo;
        $ab->porcentaje = $request->porcentaje;
        $ab->incremento = $request->incremento;
        $ab->pos = $request->pos;
        $ab->paciente_id = $request->paciente_id;
        $ab->tratmiento_id = $request->tratamiento_id ?? null;
        $ab->save();


        storeControl('Ralizo un abono');

        if ($request->tipo === 'VISA') {
            $paciente = Paciente::find($request->paciente_id);
            $paciente->deuda += $request->incremento;
            $paciente->abono +=  $request->valor + $request->incremento;
            $paciente->save();
            // dd($paciente->abono . ' Abono', $paciente->deuda . 'Deuda');

            return back()->with(['info' => 'Abono Realizado Con Exito', 'color' => 'success']);
        } else {
            // dd('entro');
            $paciente = Paciente::find($request->paciente_id);
            $paciente->abono = $paciente->abono + $request->valor;
            $paciente->save();
            return back()->with(['info' => 'Abono Realizado Con Exito', 'color' => 'success']);
        }
    }

    public function delete($id)
    {
        $abono = Abono::find($id);
        $paciente = Paciente::find($abono->paciente_id);
        $paciente->abono = $paciente->abono - $abono->valor;
        $paciente->save();
        $abono->delete();

        storeControl('Elimino un abono');


        return back()->with(['info' => 'Abono Eliminado Con Exito', 'color' => 'danger']);
    }

    // retorna todos los abonos realizados por el paciente
    public function abonos($id)
    {
        return Abono::where('paciente_id', $id)->with('tratamiento')->orderBy('id', 'desc')->get();
    }

    // retorna la vista para imprimir el recibo de abonos
    public function pritnRecibo($id)
    {
        $abono = Abono::find($id);
        $paciente = Paciente::find($abono->paciente_id);
        return view('reports.pacientes.reciboAbono', ['abono' => $abono, 'paciente' => $paciente]);
    }
}
